package gui.run;

import javax.swing.*;
import javax.vecmath.Matrix3d;
import java.awt.*;
import java.text.NumberFormat;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 11, 2005
 * Time: 2:52:24 PM
 * Copyright DocJava, 2005
 */
public class Matrix3dView extends JPanel {

    Matrix3d m = new Matrix3d();

    JLabel jla[][] = new JLabel[3][3];
    NumberFormat nf = getNumberFormat();

    public Matrix3dView() {
        setBorder(BorderFactory.createEtchedBorder());
        setLayout(new GridLayout(3, 0, 5, 5));
        m.setIdentity();
        initLabels();
        updateView(m);
    }

    private void initLabels() {

        for (int x = 0; x < jla.length; x++)
            for (int y = 0; y < jla[0].length; y++) {
                String element = nf.format(m.getElement(x, y));
                JLabel jLabel = new JLabel(element);
                jla[x][y] = jLabel;
                add(jLabel);
            }
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumIntegerDigits(1);
        return nf;
    }

    public void updateView(Matrix3d m) {
        this.m = m;
        for (int x = 0; x < jla.length; x++)
            for (int y = 0; y < jla[0].length; y++) {
                double element = this.m.getElement(x, y);
                String s = nf.format(element);
                if (element >= 0) s = "+" + s;
                jla[x][y].setText(s);
            }
        repaint();
    }
}
