/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import utils.CompactJava;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class DialBean implements Serializable {

    private String callingCardNumber ="";


    private static String key = "DialBean";
    private boolean toneDial = true;
    private boolean modemDial = true;
    private int speed = 95; //in ms

    public DialBean() {

    }

    public String toString() {
        return CompactJava.toXml(this);
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            byte[] value = baos.toByteArray();
            p.putByteArray(key, value);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



    /**
     * restores the properties from the preference in the user root.
     */
    public static DialBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new DialBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (DialBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            //e.printStackTrace();
        }
        return new DialBean();
    }



    public boolean isToneDial() {
        return toneDial;
    }

    public void setToneDial(boolean toneDial) {
        this.toneDial = toneDial;
        save();
    }

    public String getCallingCardNumber() {
        return callingCardNumber;
    }

    public void setCallingCardNumber(String callingCardNumber) {
        this.callingCardNumber = callingCardNumber;
        save();
    }

    public boolean isModemDial() {
        return modemDial;
    }

    public void setModemDial(boolean modemDial) {
        this.modemDial = modemDial;
        save();
    }

    public int getSpeed() {
        return speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        save();
    }
}
