/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import utils.StringUtils;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class DelimiterBean implements Serializable {
    private char lineDelimiter = '\t';
    private char fieldDelimiter = ',';
    private char recordDelimiter = StringUtils.NEW_LINE;


    private static String key = "DelimiterBean";

    public DelimiterBean() {

    }

    public void setToDefault() {
        lineDelimiter = '\t';
        fieldDelimiter = ',';
        recordDelimiter = StringUtils.NEW_LINE;
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "line="+lineDelimiter+" field="+ fieldDelimiter+" record="+recordDelimiter;
    }

  public static DelimiterBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new DelimiterBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (DelimiterBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new DelimiterBean();
    }

    public char getLineDelimiter() {
        return lineDelimiter;
    }

    public void setLineDelimiter(char lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public char getFieldDelimiter() {
        return fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public char getRecordDelimiter() {
        return recordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }
}
