/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 30, 2003
 * Time: 9:50:33 AM
 */
package gui.mouse;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseRotationController
        implements MouseListener, MouseMotionListener {
    //float xrot = 64;
    //float yrot = 32;
    //float zrot = 17;
    private float dx = 0;
    private float dy = 0;
    private float dz = 0;
    private float oldx,oldy;
    private boolean autorot = true;
    Rotatable r;

    public void mouseMoved(MouseEvent evt) {
    };
    public void mouseClicked(MouseEvent evt) {
    };
    public void mouseEntered(MouseEvent evt) {
    };
    public void mouseExited(MouseEvent evt) {
    }

    public MouseRotationController(Rotatable _r) {
        r = _r;
    }


    public void mousePressed(MouseEvent evt) {
        autorot = false;
        oldx = evt.getX();
        oldy = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        autorot = true;
        oldx = evt.getX();
        oldy = evt.getY();
    }

    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();

        r.rotateWorld((oldy - y), (oldx - x), 0);
        dx = (dx + oldx - x + 360) % 360;
        dy = (dy + oldy - y + 360) % 360;
        //showStatus("dx="+dx+" dy="+dy);
        oldx = x;
        oldy = y;
    }

    public boolean isAutorot() {
        return autorot;
    }
}
