/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 20, 2003
 * Time: 9:05:23 AM
 */
package gui.layouts;

import java.awt.*;

public class PreferredBoundable
        implements BoundableInterface {
    public void setBounds(Component c,
                          int x, int y,
                          int w, int h) {
        Dimension wantedSize = new Dimension(w, h);
        Dimension d = c.getPreferredSize();
        d = min(d, wantedSize);
        c.setBounds(x, y, d.width, d.height);
    }

    public Dimension min(Dimension d1, Dimension d2) {
        if (d1.width < d2.width) return d1;
        if (d1.height < d2.height) return d1;
        return d2;
    }
}
