package gui;

import javax.swing.*;
import java.awt.*;

public class ClosableJFrame extends JFrame {
    public ClosableJFrame() {
        this("");
    }

    public ClosableJFrame(String title) {
        super(title);
        JFrame.setDefaultLookAndFeelDecorated(true);

    }
    /**
     * @deprecated call setContainerLayout instead
     * @param lm
     */
    public void setLayout(LayoutManager lm){
        super.setLayout(lm);
    }
    /**
     * A way to set the layout without called getContentPane
     * in your code
     * @param lm
     */
    public void setContainerLayout(LayoutManager lm){
        Container c = getContentPane();
        c.setLayout(lm);

    }
    /**
     * @deprecated use setJMenuBar instead
     */
    public void setMenuBar(MenuBar mb){
        super.setMenuBar(mb);
    }
    /**
     * @deprecated use addComponent instead
     *
     */
    public Component add(Component c){
        return super.add(c);
    }
    /**
     * @deprecated use addComponent instead
     * @param name
     * @param comp
     * @return
     */
    public Component add(String name, Component comp){
        return super.add(name,comp);
    }
    /**
     * @deprecated use addComponent instead
     * @param co
     * @param code
     * @return
     */
    public Component add(Component co, int code){
        return super.add(co,code);

    }
   /**
    * A way to add components without calling get
    * content pane in the code.
    * @param co component to add
    * @return a reference to the component, if you need it.
    */
    public Component addComponent(Component co){
        Container c = getContentPane();
        c.add(co);
        return co;
    }
    public Component addComponent(String name, Component co) {
        Container c = getContentPane();
        c.add(name, co);
        return co;

    }
    /**
     * @deprecated use addComponent instead
     * @param comp
     * @param constraints
     */
    public void add(Component comp, Object constraints) {
        super.add(comp,constraints);

    }
    public Component addComponent( Component co, String code) {
        Container c = getContentPane();
        c.add(co,code);
        return co;

    }
    public void addMouseController(gui.mouse.MouseController mc) {
        addMouseMotionListener(mc);
        addMouseListener(mc);
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame("ClosableJFrame");
        cf.setSize(200, 200);
        cf.setVisible(true);

    }
}