package graphics.raytracers.tracer;

import graphics.raytracers.tracer.geometry.Vector3d;
import graphics.raytracers.tracer.primatives.Primitive;
import graphics.raytracers.tracer.primatives.Sphere;

import java.applet.Applet;
import java.awt.*;
import java.awt.image.ImageObserver;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Test extends
        Applet implements Runnable, ImageObserver {
    Tracer t;
    view v;
    int painted;
    Image img;
    boolean loaded;
    Thread motor;
    Dimension d;
    Graphics my_g;

    public void init() {
        Primitive p;
        double diff, spec, shine;
        int width, height;
        URL hp;
        URLConnection hpcon;
        InputStream input;
        byte scenebytes[];
        String scene;
        String sceneURL;
        int len;
        Canvas s;

        scene = "";
        sceneURL = getParameter("scene");
        System.out.println("Scene: " + scene);

        my_g = getGraphics();
        loaded = false;

        diff = 0.7;
        spec = 0.3;
        shine = 14.0;

        v = new view();
        v.setFrom(new Vector3d(10, 10, -40));
        v.setAt(new Vector3d(10, 10, -15));
        v.setUp(new Vector3d(0, 1, 0));
        v.setAngle(35.0 * 3.14159265 / 180.0);
        v.setAspect(1.0); /* 4.0/3.0; */
        v.setDist(1.0);

        width = getSize().width;
        height = getSize().height;

        t = new Tracer(width, height, v);

        p = new Sphere(new Vector3d(0, 0, 0), 10);
        p.setColor(1, 0, 0);
        p.surf.shine = shine;
        p.surf.kd = diff;
        p.surf.ks = spec;
        t.newPrim(p);

        p = new Sphere(new Vector3d(0, 20, 0), 10);
        p.setColor(0, 1, 0);
        p.surf.shine = shine;
        p.surf.kd = diff;
        p.surf.ks = spec;
        t.newPrim(p);

        p = new Sphere(new Vector3d(20, 0, 0), 10);
        p.setColor(0, 0, 1);
        p.surf.shine = shine;
        p.surf.kd = diff;
        p.surf.ks = spec;
        t.newPrim(p);

        t.newLight(new Vector3d(100, 100, -20), 1.0);
        t.newLight(new Vector3d(-100, 100, -20), 1.0);
        t.newLight(new Vector3d(100, -100, -20), 1.0);

        img = createImage(t);
    }

    public boolean imageUpdate(Image img, int info,
                               int x, int y, int width, int height) {
        if ((info & ALLBITS) != 1) {
            my_g.drawImage(img, 0, 0, this);
            return true;
        } else {
            return false;
        }
    }

    public void paint(Graphics g) {
        d = this.getSize();
        loaded = g.drawImage(img, 0, 0, this);
    }

    public void update(Graphics g) {
        paint(g);
    }

    public void start() {
        motor = new Thread(this);
        motor.start();
    }

    public void stop() {
        //motor.stop();   // this has been deprecated, DL
    }

    public void run() {
        motor.setPriority(Thread.MIN_PRIORITY);
        while (!loaded) {
            repaint();
            try {
                motor.sleep(500);
            } catch (InterruptedException e) {
            }
        }
    }
}
