package graphics.raytracers.rmiRaytracer.raytracer;

import java.util.Vector;

class Targets {
    static SceneConsts sConsts;
    Vec VRP;
    Vec light;
    private Vector targetList = new Vector(); // objects in the scene

    public int getSize() {
        return targetList.size();
    }

    public Target getElementAt(int i) {
        return (Target) targetList.elementAt(i);
    }

    public void add(Target t) {
        targetList.addElement(t);
        t.setScene(this);

    }

    public static final Targets getTargets() {
        Targets s = new Targets();

        // set up the lights and view reference point
        s.VRP = new Vec(0.0, 0.0, -1.0);
        s.light = new Vec(16.0, 8.0, -16.0);

        s.add(new SphereTarget(0.05, -0.3, 0.0, 0.3));
        s.add(new SphereTarget(0.05, 0.06, 0.0, 0.24));
        s.add(new SphereTarget(0.05, 0.19, -0.205, 0.01));
        s.add(new SphereTarget(0.05, 0.09, -0.237, 0.01));
        s.add(new SphereTarget(0.05, 0.0, -0.230, 0.01));
        s.add(new SphereTarget(0.05, 0.32, -0.205, 0.018));
        s.add(new SphereTarget(0.05, 0.34, 0.0, 0.2));
        s.add(new SphereTarget(0.1, 0.4, -0.195, 0.02));
        s.add(new SphereTarget(-0.02, 0.393, -0.185, 0.02));

        s.add(new SphereTarget(0.0, 0.0, 10, 10));
        return s;
    }
}