/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package graphics.grapher;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;

/**
 * This class contains the graphcomponent, which has the
 * axix, lbels and images of data to be graphed.
 */
public class GraphUtil  {

    private GraphComponent graphComponent =new GraphComponent();

    private Axis xaxis;
    private Axis yaxis;
    private int np;
    private DataSet dataSet;
    private double data[];

    public GraphUtil(DoubleXYData doubleXYData) {
        np = doubleXYData.getNp();
        doubleXYData.checkConsistent();
        data = new double[np * 2];
        makeAxis(doubleXYData);
    }

   private void makeAxis(DoubleXYData doubleXYData) {
        int ix = 0;
        int iy = 1;
        for (int i = 0; i < np; i++) {
            data[ix] = doubleXYData.getX()[i];
            data[iy] = doubleXYData.getY()[i];
            ix = ix + 2;
            iy = iy + 2;
        }
        graphComponent.setBackground(Color.white);
        dataSet = graphComponent.loadDataSet(data, np);
        dataSet.linecolor = new Color(0, 0, 0);
        dataSet.legendColor(new Color(0, 0, 0));




        // xaxis_t = graphComponent.createAxis(Axis.TOP);
        // xaxis_t.attachDataSet(data1);
        // xaxis_t.title = dl.x_label;

        xaxis = graphComponent.createAxis(Axis.BOTTOM);
        xaxis.attachDataSet(dataSet);
        xaxis.title = doubleXYData.getXLabel();

        yaxis = graphComponent.createAxis(Axis.RIGHT);
        yaxis.attachDataSet(dataSet);
        yaxis.title = doubleXYData.getYLabel();

    }
    public void setImageData(Image img){
        graphComponent.setImageData(img);
    }
    private JFrame getJFrame() {
        ClosableJFrame cf = new ClosableJFrame("Graph Frame");
        cf.addComponent("Center", graphComponent);
        cf.setSize(250, 250);
        cf.show();
        return cf;
    }

    public static void main(String[] args) {

        GraphUtil gf1 = new GraphUtil(getXYData(Main.getSampleY1Data()));
        GraphUtil gf2 = new GraphUtil(getXYData(Main.getSampleY2Data()));
        ClosableJFrame cf = new ClosableJFrame("Graph Frame");
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());

        c.add(gf1.graphComponent,BorderLayout.CENTER);

        cf.setSize(250, 250);
        cf.show();

    }

    private static DoubleXYData getXYData(final double[] yData) {
        double xData[] = new double[yData.length];
        for (int i = 0; i < yData.length; i++)
            xData[i] = i;
        DoubleXYData doubleXYData = new DoubleXYData(xData.length, "x", "y^2");

        doubleXYData.setX(xData);
        doubleXYData.setY(yData);
        return doubleXYData;
    }
}