package graphics.grapher;



public class DoubleXYData  {
		private int np;
		private double x[];
   		private double y[];
  
   		private TextLine xLabel;
   		private TextLine yLabel;
   		
   	public DoubleXYData(int number_of_rays,String xs, String ys) {
   		xLabel = new TextLine(xs);
   		yLabel = new TextLine(ys);
   		np = number_of_rays;
   		x = new double[np];
   		y = new double[np];

   		checkConsistent();
   	} // constructor
   	
   	public TextLine getXLabel() {
   		return xLabel;
   	}
   	
   	public TextLine getYLabel() {
   		return yLabel;
   	}
   	
	public void checkConsistent() {
		if (np <= 0) {
			System.out.println("Dl: np <= 0");
		}
	} // checkConsistent
	
	public void print(int numberOfPoints) {
		System.out.println("x3\t dl\t r");
		for (int i =0 ; i < numberOfPoints; i++) {
			System.out.println(x[i]+"\t "+y[i]);
		}
	}
	public void print() {
		System.out.println("x3\t dl\t r");
		for (int i =0 ; i < np; i++) {
			System.out.println(x[i]+"\t "+y[i]);
		}
	} // print

    public int getNp() {
        return np;
    }

    public void setNp(int np) {
        this.np = np;
    }

    public double[] getX() {
        return x;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public double[] getY() {
        return y;
    }

    public void setY(double[] y) {
        this.y = y;
    }

    public TextLine getxLabel() {
        return xLabel;
    }

    public void setxLabel(TextLine xLabel) {
        this.xLabel = xLabel;
    }

    public TextLine getyLabel() {
        return yLabel;
    }

    public void setyLabel(TextLine yLabel) {
        this.yLabel = yLabel;
    }
}