package graphics.graph;

import java.awt.*;

public class GraphManager {
    /**
     *	This is the class formerly known as GraphPanel.
     *	That name is no longer appropriate since it stopped extending Panel.
     *	It owns a Panel (ImagePanel to be precise) and its responsibility
     *	is to manager the ThreadManager, the MouseEventHandler and other
     *	business objects and insure that they all work together to update
     *	the view on the ImagePanel.
     */
    private GraphImagePanel ip = GraphImagePanel.getImagePanel();
    private EdgesManager em = GraphFactory.getEdgesManager();
    private NodeDrawer nd = GraphFactory.getNodeDrawer();
    private EdgesBean eb = EdgesBean.getEdgesBean();
    private ImageBuffer imageBuffer;
    private MouseEventHandler meh;
    private RelaxThreadMgr rtm;

    private static GraphManager gp = new GraphManager();

    private GraphManager() {
    }

    public static GraphManager getGraphManager() {
        return gp;
    }

    public RelaxThreadMgr getRelaxThreadMgr() {
        return rtm;
    }

    private ImageBuffer getImageUtil()
            /**
             *	Getter for the ImageUtil attribute
             */ {
        return imageBuffer;
    }

    public void update(java.awt.Graphics g)
            /**
             *	The responsibility of this window is to handle the business
             *	rules for how the window is supposed to be updated.
             *	ImageUtil is used to double buffer the image so it won't flicker.
             *	The NodeDrawer nd is used to actually draw where the nodes are
             *	supposed to be at that instant. The EdgesBean and the EdgesManager
             *	supply the information.
             *
             *	@param	java.awt.Graphics
             */ {
        Dimension d = ip.getSize();
        if ((getImageUtil().getOffScreen() == null) ||
                (d.width != getImageUtil().getOffScreenSize().width) ||
                (d.height != getImageUtil().getOffScreenSize().height))
            getImageUtil().createBuffer(ip.getSize());

        getImageUtil().getOffGraphics().setColor(ip.getBackground());
        getImageUtil().getOffGraphics().fillRect(0, 0, d.width, d.height);
        for (int i = 0; i < eb.getNumberOfEdges(); i++) {
            em.drawArcAndString(i);
        }
        nd.drawNodes(getImageUtil());
        g.drawImage(getImageUtil().getOffScreen(), 0, 0, null);
    }

    public void start()
            /**
             *	This method sets up all of the attributes that need
             *	to interface with the ImagePanel. This includes:
             *	<OL>
             *	<LI> ImageUtil   on which it sets the panel to ImagePanel </LI>
             *	<LI> MouseEventHandler </LI>
             *	<LI> adding MouseListener    </LI>
             *	<LI> RelaxThreadMgr    </LI>
             *	<LI> Finally, this (GraphManager) gets set on the ImagePanel as well. </LI>
             *	</OL>
             *	ImageUtil
             */ {
        imageBuffer = GraphFactory.getImageUtil();
        imageBuffer.setPanel(ip);

        ip.setGraphManager(this);
        ip.addMouseListener(meh);
        meh = new MouseEventHandler(ip);
        rtm = new RelaxThreadMgr(ip);

        getRelaxThreadMgr().start();
    }
}