package futils;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class WildFilter implements FileFilter {
    private String suffix = null;
    private String prefix = null;
    private String midfix = null;

    /**
     * Accept only those <code>File</code> instances that
     * are of type file (i.e. not directory) and end with the
     * suffix
     *
     * @param suffix a string that all file names must end with.
     */
    public WildFilter(String suffix) {
        this.suffix = suffix;
    }

    /**
     * Accept from the interface <code>FilenameFilter</code> will return
     * true if the file name begins with the prefix and ends with the
     * suffix.
     * <p/>
     * Like:
     * <br>
     * dir f*.java
     * <br>
     * This returns only those files that start with "f" and end with ".java"
     *
     * @param prefix string passed in to describe the file names beginning
     * @param suffix ending part of the file name.
     */
    public WildFilter(String prefix, String suffix) {
        this.suffix = suffix;
        this.prefix = prefix;
    }

    /**
     * Accept from the interface <code>FilenameFilter</code> will return
     * true if the file name begins with the prefix and ends with the
     * suffix.
     * <p/>
     * Like:
     * <br>
     * dir f*.java
     * <br>
     * This returns only those files that start with "f" and end with ".java"
     * The midfix has to be contained in the filename in order for this to return true;
     *
     * @param prefix string passed in to describe the file names beginning
     * @param suffix ending part of the file name.
     * @param midfix contained in the file name.
     */
    public WildFilter(String prefix, String midfix, String suffix) {
        this.suffix = suffix;
        this.prefix = prefix;
        this.midfix = midfix;
    }

    public boolean accept(File dir) {
        String name = dir.getName();
        if (prefix == null) return name.endsWith(suffix);
        if (suffix == null) return name.startsWith(prefix);
        if (midfix == null) return name.endsWith(suffix) &&
                name.startsWith(prefix);
        return name.endsWith(suffix) &&
                name.startsWith(prefix) &&
                (name.indexOf(midfix) != -1);
    }
    public FilenameFilter getFileNameFilter(){
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return WildFilter.this.accept(new File(dir,name));
            }
        };
    }
}

