package futils;

import java.util.Vector;

/**
 * CsvParser Class
 */
public class CsvParser {

    private StringBuffer sb;
    private Vector list = new Vector();
    private char delim = ',';

    /**
     * Parse the string into an array of string,
     * breaking up along the comma delimiter. The
     * delimiters are removed when you get the
     * tokens.
     *
     * @param s
     */
    public CsvParser(String s) {
        this(s, ',');
    }

    /**
     * Use the delimiter to perform the parsing.
     * Defaults to a comma.
     *
     * @param delimiter
     */
    public CsvParser(String s, char delimiter) {
        sb = new StringBuffer(s);
        delim = delimiter;
    }


    /**
     * getTokens Method
     *
     * @return	String[]	tokens
     */
    public String[] getTokens() {
        int start = 0;

        for (int i = 0; i < sb.length(); i++) {
            if (sb.charAt(i) == delim) {
                addElement(sb.toString()
                           .substring(start, i));
                start = i + 1;
            }
        }

        addElement(
                sb.toString().substring(start,
                                        sb.length()));

        String strObj[] = new String[list.size()];


        for (int i = 0; i < list.size(); i++) {
            strObj[i] =
            (String) list.elementAt(i);
        }
        return strObj;
    }

    private void addElement(String s) {
        list.addElement(s.trim());
    }

    public static void main(String[] args) {
        testCsdParser();
    }

    public static void testCsdParser() {
        System.out.println("ParseOn comma");

        String sample = "these, are,  " +
                        ";43 345 &*(); :colon, " +
                        "+ comma, :values";
        System.out.println("sample=" + sample);
        CsvParser cp = new CsvParser(sample,
                                     ',');
        print(cp.getTokens());
        System.out.println("sample=" + sample);
        System.out.println(
                "now parse on :----->");
        cp = new CsvParser(sample, ':');
        print(cp.getTokens());
    }


    public static void testCsvParser() {

        String sample = "these, are,  ;43 345 &*(); comma, + separated, :values";
        System.out.println("sample=" + sample);
        CsvParser cp = new CsvParser(sample);
        print(cp.getTokens());

        System.out.println(
                "now parse on ;----->");
        cp = new CsvParser(sample, ';');
        print(cp.getTokens());
    }

    public static void print(String[] s) {
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i]);
    }

}
