package collections.sortable;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;


public class SortableVector {
    private final Vector v = new Vector();

    public static void main(String args[]) {
        testSort();

    }
    public void copyInto(Object o[]) {
        v.copyInto(o);
    }
    private static void testSort() {
        SortableVector v = new SortableVector();
        String s[] = {"tom", "dick", "harry"};

        for (int i = 0; i < s.length; i++)
            v.addElement(s[i]);
        v.print();
        v.sort();
        v.print();
    }

    /**
     * Start looking from the startPoint for the
     * <code>key</code> and return the location,
     * if you find it. Return -1 if you do not
     * find it.
     *
     * @param key
     * @param startPoint
     * @return
     */
    public int find(Comparable key,
                    int startPoint) {
        if (startPoint >= v.size()) return -1;
        if (key == null) return -1;
        for (int i = startPoint; i < v.size(); i++) {
            Comparable me = elementAt(i);
            if (me.compareTo(key) == 0) return i;
        }
        return -1;
    }

    public SortableVector() {
    };
    public void print() {
        for (int i = 0; i < v.size(); i++)
            System.out.println(v.elementAt(i));
    }

    private void swap(int i, int j) {
        Object o1 = v.elementAt(i);
        Object o2 = v.elementAt(j);
        v.setElementAt(o2, i);
        v.setElementAt(o1, j);
    }

    public void bubbleSort() {
        for (int i = v.size(); --i >= 0;) {
            for (int j = 0; j < i; j++) {
                Comparable c1 = (Comparable)
                        v.elementAt(j);
                Comparable c2 = (Comparable)
                        v.elementAt(j + 1);
                int c = c1.compareTo(c2);
                if (c > 0)
                    swap(j, j + 1);
            }
        }
    }

    public boolean isEmpty() {
        return v.isEmpty();
    }

    public boolean contains(Comparable o) {
        return v.contains(o);
    }

    public Comparable[] toArray() {
        return (Comparable[]) v.toArray();
    }


    public boolean remove(Comparable o) {
        return v.remove(o);
    }

    public boolean add(Comparable o) {
        return v.add(o);
    }

    public synchronized int size() {
        return v.size();
    }

    public synchronized Comparable elementAt(
            int index) {
        return (Comparable) v.elementAt(index);
    }

    public synchronized void setElementAt(
            Comparable obj, int index) {
        v.setElementAt(obj, index);
    }

    public synchronized void removeElementAt(
            int index) {
        v.removeElementAt(index);

    }

    public void sort(Comparator c) {
      Collections.sort(v,c);  
    }

    public synchronized void addElement(
            Comparable obj) {
        v.addElement(obj);
    }

    public void sort() {
        Collections.sort(v);
    }
}