/*
 * Party.java
 *
 * Created on December 4, 2002
 */

package collections.arrayList;

/**
 * A Dinner Party object.
 * @author Thomas Rowland
 */
public class Party {

    private String partyName;
    private int partySize;

    public Party(String name, int size) {
        partyName = name;
        partySize = size;
    }

    public Party(String name) {
        partyName = name;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Party p = (Party) o;
            return (p.getName().equals(partyName));
        }
        return false;
    }

    public int hashCode() {
        return partyName.hashCode();
    }

    public String getName() {
        return partyName;
    }

    public int getPartySize() {
        return partySize;
    }

    public String toString() {
        return partyName + ", party of " + partySize;
    }
}
