package classUtils.pathUtils;

import java.util.ArrayList;


public class ClassPathContainer extends ClassPathNode {
    ArrayList _children = new ArrayList();

    public ClassPathContainer(String title) {
        super(title);
    }

    public void addChild(ClassPathNode child) {
        child.setParent(this);
        _children.add(child);
    }

    // tree node interface implementation
    public Object getChild(int index) {
        return _children.get(index);
    }

    public int getChildCount() {
        return _children.size();
    }

    public boolean isLeaf() {
        return false;
    }

    public int getIndexOfChild(Object child) {
        return _children.indexOf(child);
    }
}
  

