/*

 * @(#)AttributeInfo.java	1.4 95/08/16 Chuck McManis

 *

 * Copyright (c) 1996 Chuck McManis, All Rights Reserved.

 *

 * Permission to use, copy, modify, and distribute this software

 * and its documentation for NON-COMMERCIAL purposes and without

 * fee is hereby granted provided that this copyright notice

 * appears in all copies.

 *

 * CHUCK MCMANIS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY

 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED

 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A

 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. CHUCK MCMANIS SHALL NOT BE

 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,

 * MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

 */


package classUtils.dumper;


import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;


/**

 * This class defines the generic Attribute type for Java class files.

 * It is a little bit smart in that for some Attributes it can display

 * them intelligently if it also has access to the constant pool of the

 * current class.

 *

 * @version 	1.4, 16 Aug 1995

 * @author	Chuck McManis

 * @see		ClassFile

 */

public class AttributeInfo {

    private ConstantPoolInfo name;	// attribute name

    private byte data[]; // attribute's contents


    public AttributeInfo(ConstantPoolInfo newName, byte newData[]) {

        setName(getName());

        setData(newData);

    }


    public AttributeInfo() {

    }


    public boolean read(DataInputStream di, ConstantPoolInfo pool[])

            throws IOException {

        int len;


        setName(pool[di.readShort()]);

        len = di.readInt();

        setData(new byte[len]);

        len = di.read(getData());

        if (len != getData().length)

            return (false);

        return (true);

    }


    public void write(DataOutputStream dos, ConstantPoolInfo pool[])

            throws IOException, Exception {

        dos.writeShort(ConstantPoolInfo.indexOf(getName(), pool));

        dos.writeInt(getData().length);

        dos.write(getData(), 0, getData().length);

    }


    short indexFromBytes(byte a[]) {

        return (short) (((a[0] << 8) & (0xff << 8)) |

                ((a[1] << 0) & (0xff << 0)));

    }


    public String toString(ConstantPoolInfo pool[]) {

        StringBuffer x = new StringBuffer();

        String type = getName().toString();

        ConstantPoolInfo item;


        if (type.compareTo("ConstantValue") == 0) {

            item = pool[indexFromBytes(getData())];

            return (item.toString());

        } else if (type.compareTo("SourceFile") == 0) {

            item = pool[indexFromBytes(getData())];

            return (item.toString());

        } else {

            x.append(type + "<" + getData().length + " bytes>");

        }

        return (x.toString());

    }


    public String toBoolean(ConstantPoolInfo pool[]) {

        ConstantPoolInfo item = pool[indexFromBytes(getData())];


        if (item.intValue == 0)

            return ("= false");

        return ("= true");

    }


    public String toString() {

        return (getName().toString() + " <" + getData().length + " bytes>");

    }

    ConstantPoolInfo getName() {
        return name;
    }

    void setName(ConstantPoolInfo name) {
        this.name = name;
    }

    byte[] getData() {
        return data;
    }

    void setData(byte[] data) {
        this.data = data;
    }

}

