/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package bookExamples.ch44Printing;

import futils.Futil;

import javax.print.*;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PrintImage {
    public PrintImage(File filename) {
        try {
            PrintRequestAttributeSet pras =
                    new HashPrintRequestAttributeSet();
            pras.add(new Copies(1));

            PrintService pss[] =
                    PrintServiceLookup.lookupPrintServices(
                            DocFlavor.INPUT_STREAM.GIF, pras);

            if (pss.length == 0)
                throw new RuntimeException(
                        "No printer services available.");

            PrintService ps = pss[0];
            System.out.println("Printing to " + ps);

            DocPrintJob job = ps.createPrintJob();

            FileInputStream fin = new FileInputStream(filename);
            Doc doc = new SimpleDoc(
                    fin,
                    DocFlavor.INPUT_STREAM.GIF, null);

            job.print(doc, pras);

            fin.close();
        } catch (IOException ie) {
            ie.printStackTrace();
        } catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    static public void main(String args[]) throws Exception {


        new PrintImage(Futil.getReadFile("select an image"));
    }
}
