package bookExamples.ch27BusinessGraphics.charts;

import java.awt.*;

/**
 * ColorUtils generates
 * bright colors for each slice of the pie.
 * Requires an integer indicating how many slices there are altogether
 * to be constructed.<BR>
 * Global variables:
 * <UL>
 * <LI> ColorMap: An array of colors, initialized to null
 * </UL>
 *
 * @author	Allison McHenry
 * @author	Douglas Lyon, PhD
 * @since	JDK 1.3
 */


public class ColorUtils {

    private Color colorMap [] = null;

    /**
     *	Constructor containing number of slices of pie that need to be drawn.
     *	Calls getColorMap function which gets each color.
     *	@param nc	Total number of colors needed (xVals.length)
     *	@see		#getColorMap
     */
    public ColorUtils(int nc) {
        initColorMap(nc);
    }

    /**
     *	Creates the Color Map using the HSB (hue, saturation, brightness)
     *	color scale, guaranteeing that each color will be fully satuated (1),
     *	fully bright(1) and of a random hue(h).
     *	Colors are more differentiated if there are few of them.
     *
     *	@param n 	Number of colors needed, from constructor
     *	@return c 	An array of colors to be used in drawing the pie
     *	@see		java.awt.Color.#HSBtoRGB
     */
    private void initColorMap(int n) {
        Color c [] = new Color[n];
        int i = 0;
        for (float h = 0; i < c.length; h = (float) (h + 1.0 / n)) {
            c[i] = new Color(Color.HSBtoRGB(h, 1, 1));
            i++;
        }
        colorMap = c;
    }

    public Color[] getColorMap() {
        return colorMap;
    }


    /**
     *	Walks through the
     *	array of colors and matches the data at index i with the color in
     *	the color map at index i.
     *
     *	@param i 	Which specific slice is being drawn right now
     *	@return c 	One color from the color map to be used in drawing this slice
     *	@see		PieGraph.#drawGraph
     */
    public Color getColor(int i) {
        return colorMap[i % colorMap.length];
    }

    public static int getIntColor(int r, int g, int b) {
        return 0xff000000 | (r << 16) | (g << 8) | b;
    }
}