package bookExamples.ch26Graphics.radar;

import javax.swing.*;
import java.awt.*;

public class JRadar extends JComponent {
    private double thetaInRadians = 0;
    private Target targets[] = {
        new Target("t1", 30, 50)
    };

    JRadar(int w, int h) {
        setSize(w, h);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void paint(Graphics g) {
        Dimension d = getSize();
        double deltaTheta =
                3 * Math.PI / 180.0;
        int width = d.width;
        int height = d.height;
        int xc = width / 2;
        int yc = height / 2;
        g.setColor(Color.red);
        int r = Math.min(xc, yc);
        double xr =
                r * Math.cos(getThetaInRadians()) + xc;
        double yr =
                r * Math.sin(getThetaInRadians()) + yc;
        setThetaInRadians(getThetaInRadians() + deltaTheta);
        //for (int i = 0; i < getTargets().length; i++)
        //    getTargets()[i].draw(g);
        // g.setXORMode(Color.red);
        g.drawLine(xc, yc, (int) xr, (int) yr);
        g.setColor(Color.BLUE);
        g.drawString("target", (int) xr, (int) yr);
        g.setColor(Color.cyan);
        g.drawRect(0, 0, width - 5, height - 5);
        //sleep(10);
        repaint();
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        Container c = cf.getContentPane();
        c.setBackground(Color.BLACK);
        for (int i = 0; i < 50; i++)
            c.add(new JRadar(200, 200));
        c.setLayout(new GridLayout(10, 0));
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

    public double getThetaInRadians() {
        return thetaInRadians;
    }

    public void setThetaInRadians(double thetaInRadians) {
        this.thetaInRadians = thetaInRadians;
    }

    public Target[] getTargets() {
        return targets;
    }

    public void setTargets(Target[] targets) {
        this.targets = targets;
    }
}
