package bookExamples.ch26Graphics.draw2d;

import math.Mat3;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;

public class  Spiral extends DJShape implements Drawable {

    private Polygon p = new Polygon();
    private Mat3 at;

    public Polygon getPolygon() {
        return at.transform(p);
    }

    public Point getCenter(){
        return new Point(x1,y1);
    }

    public Spiral(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        p.addPoint(x1, y1);
        p.addPoint(x2, y1);
        p.addPoint(x2, y2);
        p.addPoint(x1, y2);
        Mat3 tr1 = new Mat3();
        Mat3 tr2 = new Mat3();
        Mat3 rt = new Mat3();
        Mat3 sc = new Mat3();

        tr1.setTranslation(getCentroidX(), getCentroidY());
        sc.setScale(1, 1);
        rt.setRotation(0);
        tr2.setTranslation(-getCentroidX(), -getCentroidY());
        at = tr1.multiply(rt);
        at = at.multiply(sc);
        at = at.multiply(tr2);
    }

    int[] getCentroid() {
        Point p = getCenter();
        int[] i = new int[2];
        i[0] = (int) p.getX();
        i[1] = (int) p.getY();
        return i;
    }

    private int getCentroidX() {
        return getCentroid()[0];
    }

    public void setShear(double theta, double shx, double shy) {
        Mat3 tr1 = new Mat3();
        Mat3 tr2 = new Mat3();
        Mat3 rt = new Mat3();
        Mat3 sc = new Mat3();


        tr1.setTranslation(getCentroidX(), getCentroidY());
        sc.setShear(shx, shy);
        rt.setRotation(theta);
        tr2.setTranslation(-getCentroidX(), -getCentroidY());
        at = tr1.multiply(rt);
        at = at.multiply(sc);
        at = at.multiply(tr2);

    }

    private int getCentroidY() {
        return getCentroid()[1];
    }

    // this is what drawPolygon does
    // but slow, so you can understand the code.
    public void drawPolygon2(Graphics g, Polygon p) {
        int n = p.xpoints.length;
        for (int i = 0; i < n - 1; i++)
            g.drawLine(p.xpoints[i], p.ypoints[i],
                    p.xpoints[i + 1], p.ypoints[i + 1]);
        g.drawLine(p.xpoints[0], p.ypoints[0],
                p.xpoints[n - 1], p.ypoints[n - 1]);
    }

    public void drawPolygon(Graphics g, Polygon p) {
        Graphics2D g2d = (Graphics2D) g;
        g2d.draw(p);
    }

    private Mat3 tr1 = new Mat3();
    private Mat3 tr2 = new Mat3();
    private Mat3 rt = new Mat3();


    // Here we spin the points in the
    // shape to give the appearance of spinning the shape.
    public void drawMat3(Graphics g) {
        final int xc = getCentroidX();
        final int yc = getCentroidY();
        tr1.setTranslation(xc, yc);
        tr2.setTranslation(-xc, -getCentroidY());
        for (float theta = 0; theta < 360; theta += 10f) {

            rt.setRotation(theta);
            at = tr1.multiply(rt);
            at = at.multiply(tr2);
            drawPolygon(g, at.transform(p));
        }
    }

    // Here we spin the graphics context
    // to give the appearance of spinning
    // the shape
    public void drawRotateGraphics(Graphics g) {
        final int xc = getCentroidX();
        final int yc = getCentroidY();
        Graphics2D g2d = (Graphics2D) g;
        AffineTransform saveAt = g2d.getTransform();
        for (float theta = 0; theta <= 360; theta += 10f) {
            g2d.setTransform(AffineTransform.getRotateInstance(
                    theta * PI_ON_180,
                    xc, yc));
            g2d.draw(p);
        }
        g2d.setTransform(saveAt);
        // This leaves the g2d back on 0 degrees of rotation
    }

    // How can we use affine transforms to
    // rotate the points, rather than rotate the graphics context?
    // affinetransform.createTransformedShape(shape)
    public void drawTransformedShape(Graphics g) {
        final int xc = getCentroidX();
        final int yc = getCentroidY();
        Graphics2D g2d = (Graphics2D) g;
        for (float theta = 0; theta <= 360; theta += 10f) {
            final AffineTransform at = AffineTransform.getRotateInstance(theta *
                    PI_ON_180,
                    xc, yc);
            g2d.draw(at.createTransformedShape(p));
        }
        // This leaves the g2d back on 0 degrees of rotation
    }
    // There are 3 different ways to draw
    // a rotated 2d shape.
    // All are correct, and, depending on application,
    // all have their uses.
    public void draw(Graphics g){
        this.drawTransformedShape(g);
        //this.drawRotateGraphics(g);
        //this.drawMat3(g);
    }
    private static final double PI_ON_180
            = Math.PI / 180f;


    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Spiral(x1, y1, x2, y2);
    }


    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}