/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 2, 2004
 * Time: 3:55:54 PM
 * To change this template use Options | File Templates.
 */
package bookExamples.ch26Graphics.draw2d;

import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.beans.PropertyEditorSupport;

public class SineFcn extends PropertyEditorSupport
        implements PropertyEditorFcn1 {
    private double amplitude = 100;
    private double dcOffset = 100;
    private double frequency = 100;


    public SineFcn() {
        this(100, 100, 100);
    }

    public SineFcn(double amplitude, double dcOffset, double frequency) {
        this.amplitude = amplitude;
        this.dcOffset = dcOffset;
        this.frequency = frequency;
    }


    /**
     * Determines whether the propertyEditor can provide a custom editor.
     *
     * @return True if the propertyEditor can provide a custom editor.
     */
    public boolean supportsCustomEditor() {
        return true;
    }

    public void update() {
        super.setValue(this);
        firePropertyChange();
    }

    public java.awt.Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("freq"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, 100) {
            public void run() {
                frequency = getValue();
                SineFcn.this.update();
            }
        });
        return jp;
    }

    private static final double TWO_PI = 2 * Math.PI;

    public Point2D getPoint(double t) {
        double u = TWO_PI * t;
        float x = (float) u;
        float y = (float) (amplitude * Math.sin((u / TWO_PI) * frequency) + dcOffset);
        return new Point2D.Float(x, y);
    }
}
