package bookExamples.ch26Graphics.draw2d;


import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyEditor;

public class Line2d extends DJShape implements PropertyEditor {
    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Line2d(x1, y1, x2, y2);
    }

    public Line2d(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
    }

    public Point getCenter() {
        return new Point((x2 - x1) / 2, (y2 - y1) / 2);
    }

    public Line2d(Vec2d v1, Vec2d v2) {
        super((int) v1.v[0], (int) v1.v[1], (int) v2.v[0], (int) v2.v[1]);
    }

    public void draw(Graphics g) {
        Color c = g.getColor();
        g.setColor(getForeground());
        Graphics2D g2d = (Graphics2D) g;
        g2d.drawLine(x1, y1, x2, y2);
        g.setColor(c);
    }

    public String toString() {
        return
                "x1,y1,x2,y2=" + x1 + "," + y1 + "," + x2 + "," + y2;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Point pc = getCenter();
        int xc = pc.x;
        int yc = pc.y;
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("y1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, yc) {
            public void run() {
                y1 = getValue();
                pcs.firePropertyChange("size", Line2d.this, null);
            }
        });

        jp.add(new JLabel("x1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, xc) {
            public void run() {
                x1 = getValue();
                pcs.firePropertyChange("size", Line2d.this, null);
            }
        });

        jp.add(new RunButton("setForeground") {
            public void run() {
                Line2d.this.setForeground(In.getColor());
                //  pcs.firePropertyChange("Octagon",null,this);
                pcs.firePropertyChange("size", Line2d.this, null);
            }
        });

        jp.setLayout(new FlowLayout());

        return jp;
    }

    public Object getValue() {
        return this;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
