package bookExamples.ch26Graphics;

import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;

public class ClockFrame extends JFrame {
    JLabel jl = new JLabel(
            new java.util.Date().toString());
    Container container = super.getContentPane();
    JPanel bcp = new JPanel();
    RunButton toggleButton = new RunButton("stop/start") {
        public void run() {
            System.out.println("start/stop was clicked");
            isRunning = !isRunning;
            System.out.println("isRunning=" + isRunning);
            repaint();
        }
    };

    public ClockFrame() {
        setSize(400, 400);
        container.setLayout(new BorderLayout());
        container.add(jl, BorderLayout.CENTER);
        bcp.setLayout(new FlowLayout());
        bcp.add(toggleButton);
        container.add(bcp, BorderLayout.SOUTH);
        setVisible(true);
    }

    public static void main(String args[]) {
        new ClockFrame();
    }

    private boolean isRunning = true;

    // In order to get the toggle button to alternately select
    // whether the JLabel was showing the updated time
    // I changed the following method so that the JLabel is
    // repainted every time paint is called, but setText is
    // only called when isRunning is true.
    public void paint(Graphics g) {
        if (isRunning)
            jl.setText(new java.util.Date().toString());
        super.paint(g);
        //if (isRunning) repaint(1000);
        repaint();
    }
}

