package bookExamples.ch18Swing.awt;

import gui.layouts.BoundableComponentPlacement;
import gui.layouts.PreferredSizeGridLayout;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;

public class LayoutExample {
    public static void flowLayoutExample() {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();
        c.setLayout(new FlowLayout());
        for (int i = 0; i < 100; i++) {
            c.add(new JButton("OK"));
            c.add(new JButton("cancel"));
            c.add(new JCheckBox("i="+i));
        }
        jf.setSize(200, 200);
        jf.setVisible(true);
    }

    public static JButton getOkButton() {
        JButton jb = new JButton("ok");
        jb.setMinimumSize(jb.getPreferredSize());
        jb.setMaximumSize(jb.getPreferredSize());
        //jb.setAlignmentX(Component.LEFT_ALIGNMENT);
        return jb;
    }

    public static JButton getCancelButton() {
        JButton jb = new JButton("cancel");
        jb.setMinimumSize(jb.getPreferredSize());
        jb.setMaximumSize(jb.getPreferredSize());
        ///jb.setAlignmentX(Component.RIGHT_ALIGNMENT);
        return jb;
    }

    public static void PreferredSizeGridLayoutExample() {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();
        PreferredSizeGridLayout psgl =
                new PreferredSizeGridLayout(0, 2, 0, 0);
        psgl.setBoundableInterface(new BoundableComponentPlacement());
        c.setLayout(psgl);
        for (int i = 0; i < 5; i++) {
            //rb.setAlignment((int)(Math.random()*8+1));
            c.add(new RunButton("ok" + i) {
                public void run() {
                }
            });
            c.add(new RunButton("Cancel" + i) {
                public void run() {
                }
            });
        }
        jf.setSize(200, 200);
        jf.setVisible(true);
    }

    public static void main(String args[]) {
        PreferredSizeGridLayoutExample();
        GridLayoutExample();
        flowLayoutExample();
        BorderLayoutExample();
    }

    public static void GridLayoutExample() {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();
        c.setLayout(new GridLayout(3, 0));
        c.add(new JButton("OK"));
        c.add(new JButton("cancel"));
        c.add(new JButton("OK"));
        c.add(new JButton("cancel"));
        c.add(new JButton("OK"));
        c.add(new JButton("cancel"));
        c.add(new JButton("OK"));
        c.add(new JButton("cancel"));
        c.add(new JButton("OK"));
        c.add(new JButton("cancel"));
        jf.setSize(200, 200);
        jf.setVisible(true);
    }

    public static void BorderLayoutExample() {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(new JButton("N"), BorderLayout.NORTH);
        c.add(new JButton("S"), BorderLayout.SOUTH);
        c.add(new JButton("E"), BorderLayout.EAST);
        c.add(new JButton("C"), BorderLayout.CENTER);
        c.add(new JButton("W"), BorderLayout.WEST);
        jf.setSize(200, 200);
        jf.setVisible(true);
    }

    public static JPanel getDialPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(new JButton("dial"));
        jp.add(new JButton("dial"));
        jp.add(new JButton("dial"));
        return jp;
    }

    private static JPanel getPhoneNumberPanel() {
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(0, 1));
        textPanel.add(new JTextField(20));
        textPanel.add(new JTextField(20));
        textPanel.add(new JTextField(20));
        return textPanel;
    }

    public static void addressBook() {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();
        c.add(getDialPanel(), BorderLayout.EAST);
        c.add(getPhoneNumberPanel(), BorderLayout.CENTER);
        c.add(getDialPanel(), BorderLayout.WEST);
        jf.setSize(200, 200);
        jf.setVisible(true);
    }
}

