package bookExamples.ch08ArraysAndVectors.maze;


public class MazeGenerator {
    private final char space = '.';
    private final char wall = '#';
    private final char start = 'S';
    private final char end = 'E';
    private char maze[][] = null;
    private static int a = 20;
    private static int d = 20;

    public void markStart(java.awt.Point p) {
        getMaze()[p.x][p.y] = getStart();
    }

    public int frand(int s, int e) {
        return s + (int) (Math.random() * (e - s));
    }

    public void markEnd(java.awt.Point p) {
        getMaze()[p.x][p.y] = getEnd();
    }

    public MazeGenerator(int w, int h) {
        setMaze(new char[w][h]);
        init();
    }

    public static void main(String args[]) {
        int x = (int) (Math.random() * 10) + (int) (Math.random() * 10);
        int y = (int) (Math.random() * 10);

        MazeGenerator mg = new MazeGenerator(getA(), getD());

        mg.markStart(new java.awt.Point(1, 1));
        mg.markEnd(new java.awt.Point((getA() - 2), getD() - 2));
        mg.print(mg.getStringArray());

        String mazeString[] = mg.getStringArray();

        MazeUtility.setMazeString(mazeString);
        MazeUtility.solve();
        MazeUtility.print();
    }

    public void init() {
        fillWithSpaces();
        addWall3();
        addWall2();
        addWall1();
        addWall0();
        addinnerwalls();

    }

    public void addWall1() {
        for (int y = 0; y < getMaze().length; y++)
            getMaze()[y][getMaze()[0].length - 1] = getWall();
    }

    public void addWall2() {
        for (int x = 0; x < getMaze()[0].length; x++)
            getMaze()[getMaze().length - 1][x] = getWall();
    }

    public void addWall3() {
        for (int y = 0; y < getMaze().length; y++)
            getMaze()[y][0] = getWall();
    }

    public void addWall0() {
        for (int x = 0; x < getMaze()[0].length; x++)
            getMaze()[0][x] = getWall();
    }

    public void fillWithSpaces() {
        for (int r = 0; r < getMaze().length; r++)
            for (int col = 0; col < getMaze()[r].length; col++)
                getMaze()[r][col] = getSpace();
    }

    public void addinnerwalls() {
        for (int r = 0; r < getMaze().length - 1; r++) {
            int x = (int) (Math.random() * 10 + 1);
            int y = (int) (Math.random() * 10 + 1);
            getMaze()[x][y] = getWall();

            for (int col = 0; col < getMaze()[r].length - 1; col++)
                getMaze()[x + (getA() - 12)][y] = getWall();

            for (int col = 0; col < getMaze()[r].length - 1; col++)
                getMaze()[x][y + (getA() - 12)] = getWall();

            for (int col = 0; col < getMaze()[r].length - 1; col++)
                getMaze()[x + (getA() - 12)][y + (getA() - 12)] = getWall();

            for (int col = 0; col < getMaze()[r].length - 1; col++)
                getMaze()[x][y] = getWall();

            for (int col = 0; col < getMaze()[r].length - 1; col++)
                getMaze()[x][y] = getWall();

            if (getA() > 20)
                for (int col = 0; col < getMaze()[r].length - 1; col++) {
                    for (int z = 5; z < 26; z++) {
                        getMaze()[15][z] = getWall();
                        getMaze()[z][15] = getWall();
                        getMaze()[z - 1][16] = getWall();
                        getMaze()[16][z - 1] = getWall();
                    }
                }

        }
    }

    public String[] getStringArray() {
        String s[] = new String[getMaze().length];
        for (int r = 0; r < getMaze().length; r++)
            s[r] = new String(getMaze()[r]);
        return s;
    }

    public void print(String a[]) {
        for (int i = 0; i < a.length; i++)
            System.out.println(a[i]);
    }

    public void print() {
        for (int r = 0; r < getMaze().length; r++) {
            System.out.println();
            for (int col = 0; col < getMaze()[r].length; col++)
                System.out.print(getMaze()[r][col]);
        }
    }

    public char getSpace() {
        return space;
    }

    public char getWall() {
        return wall;
    }

    public char getStart() {
        return start;
    }

    public char getEnd() {
        return end;
    }

    public char[][] getMaze() {
        return maze;
    }

    public void setMaze(char[][] maze) {
        this.maze = maze;
    }

    public static int getA() {
        return a;
    }

    public static void setA(int a) {
        MazeGenerator.a = a;
    }

    public static int getD() {
        return d;
    }

    public static void setD(int d) {
        MazeGenerator.d = d;
    }
}



