/*
 * StringSwitch.java
 *
 * Created on October 30, 2002, 1:18 PM
 */

package bookExamples.ch05ControlStructs;


import java.util.HashMap;
import java.util.Map;

/**
 *	StringSwitch class - shows how to build a class
 *	that supports switch based on strings.
 *	@author Thomas Rowland and Douglas A. Lyon
 *	@version October 30, 2002, 1:18 PM
 */
class StringSwitch {

    /** Map used to store String-int mappings and provide fast lookup */
    private Map map = new HashMap();

    /**
     *  Adds a key-value pair to the hashmap.
     *  Map.put provides constant-time performance.
     *  @param key the key object, which is a String
     *  @param value the value, which is an int
     */
    protected final void add(String key, final int value) {
        map.put(key, new Integer(value));
    }

    /**
     *  Retrieves a value from the hashmap give the key.
     *  Map.put provides constant-time performance.
     *  @param key the key object, which is a String
     *  @return the value to which the key is mapped
     */
    protected int getIdForString(String key) {
        return ((Integer) map.get(key)).intValue();
    }
}//class
