package addbk.print.labels;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Jun 6, 2005
 * Time: 9:17:48 AM
 * To change this template use File | Settings | File Templates.
 */
public class ColumnListener extends MouseAdapter {
    private DymoLabelTable dymoLabelTable;

    public ColumnListener(DymoLabelTable dymoLabelTable) {
        this.dymoLabelTable = dymoLabelTable;
    }

    public void mouseClicked(MouseEvent e) {
        TableColumnModel colModel = dymoLabelTable.m_table.getColumnModel();
        int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
        int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();

        if (modelIndex < 0)
            return;
        if (dymoLabelTable.m_data.m_sortCol == modelIndex)
            dymoLabelTable.m_data.m_sortAsc = !dymoLabelTable.m_data.m_sortAsc;
        else
            dymoLabelTable.m_data.m_sortCol = modelIndex;

        for (int i=0; i < dymoLabelTable.m_data.getColumnCount(); i++) {
            TableColumn column = colModel.getColumn(i);
            int index = column.getModelIndex();
            JLabel renderer = (JLabel)column.getHeaderRenderer();
            renderer.setIcon(dymoLabelTable.m_data.getColumnIcon(index));
        }
        dymoLabelTable.m_table.getTableHeader().repaint();
        dymoLabelTable.m_table.tableChanged(new TableModelEvent(dymoLabelTable.m_data));
        dymoLabelTable.m_table.repaint();
    }
}
