package addbk.print;


import addbk.print.labels.PrintPreview;

import java.awt.*;
import java.awt.print.*;

public class DymoPrinter implements Printable {

    public static void main(String[] args) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        Dimension d = new Dimension(252,79);
        paper.setSize(600, 400);
        paper.setImageableArea(0, 0, 600, 400);
        final int orientation = PageFormat.LANDSCAPE;
        pageFormat.setOrientation(orientation);
        pageFormat.setPaper(paper);
        new PrintPreview(
                new DymoPrinter(),
                "Dymo Preview",orientation);
    }


    public int print(
            Graphics g,
            PageFormat pageFormat,
            int pageIndex) throws PrinterException {
        // make (0,0) origin of printable area.
        System.out.println("pageIndex="+pageIndex);
        if (pageIndex != 0) return NO_SUCH_PAGE;
        final int w = (int) pageFormat.getWidth();
        final int h = (int) pageFormat.getHeight();
        System.out.println("w,h="+w+","+h);
        for (int i=0; i < w; i = i + 10){
            for (int j=0; j < h; j = j+ 10){
                g.drawRect(0,0,i,j);
            }
        }

        return PAGE_EXISTS;


    }


}

