//Paul S. Underwood
//SW409 Final
//May 3, 2005

//Borrowed from chapter 44

package addbk.JAddressBook;

import gui.run.LabelBean;
import utils.StringWacker;

import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
public class PrintableLabel
        implements Printable {
    private Graphics2D g;
    private int xoff, yoff;
    private static final int INCH = 72; //picas
    private AddressDataBase adb;
    private LabelBean lb = LabelBean.restore();
    private int columns;
    private int labelWidth;
    private int labelHeight;
    static final int PAGE_WIDTH = 240;//216; //millimeters
    static final int PAGE_HEIGHT = 310;//279; //millimeters
    static final int PICAS_PER_MILLIMETER = 3;
    private Font font;

    public PrintableLabel(AddressDataBase v, Font f) {
        adb = v;
        font = f;

        xoff = lb.getLeftMargin() * PICAS_PER_MILLIMETER;
        yoff = lb.getTopMargin() * PICAS_PER_MILLIMETER;
        columns = lb.getNumberOfLabels() / lb.getNumberOfLabelsPerColumn();
        labelWidth = (PAGE_WIDTH - (lb.getLeftMargin()
                + lb.getRightMargin()
                + (columns - 1) * lb.getHorizontalGutter()
                )
                ) / columns;
        labelHeight = (PAGE_HEIGHT - (lb.getTopMargin()
                + lb.getBottomMargin()
                + ((lb.getNumberOfLabelsPerColumn() - 1)
                * (lb.getVerticalGutter())
                )
                )
                ) / lb.getNumberOfLabelsPerColumn();
        labelWidth *= PICAS_PER_MILLIMETER;
        labelHeight *= PICAS_PER_MILLIMETER;
    }

    //-----------
    //called by printing system
    //note that this simplistic example only prints page 0
    public int print(Graphics gr, PageFormat pageFormat, int page)
            throws PrinterException {
        this.g = (Graphics2D) gr;
        printPage(page);
        return PAGE_EXISTS;
    }

    private void printPage(int page) {
        adb.setRecordNumber(page * lb.getNumberOfLabels());
        xoff = lb.getLeftMargin();
        yoff = lb.getTopMargin();
        AddressRecord[] ar = adb.getNextRecords(lb.getNumberOfLabels());
        for (int i = 0; i < lb.getNumberOfLabels(); i++)
            printLabel(ar[i]);
    }


    private String getShortString(String str){
        int width = labelWidth - INCH / 4;
        StringWacker sr = new StringWacker(width, str,font,g);
        return sr.getShortString();
    }


    //Break the given string into strings (space delimited)
    //which will fit on the given label with the given
    //font.
    private Lines substringify(String str) {
        Lines v = new Lines();
        String sub = str;
        Rectangle2D rect = font.getStringBounds(str,
                0,
                str.length(),
                g.getFontRenderContext());
        while (rect.getWidth() > labelWidth - INCH / 4) {
            String temp = getShortString(sub);
            v.add(temp);
            sub = sub.substring(temp.length());
            rect = font.getStringBounds(sub,
                    0,
                    sub.length(),
                    g.getFontRenderContext());
        }
        v.add(sub);
        return v;
    }
    class Lines {
        private Vector v = new Vector();

        public void add(String s) {
            v.add(s);
        }

        public String elementAt(int i) {
            return (String) v.elementAt(i);
        }

        public int size() {
            return v.size();
        }

        public void removeAllElements() {
            v.removeAllElements();
        }

        public void set(Lines vector) {
            v = vector.v;
        }
    }
    private void printLabel(AddressRecord ar) {
//        g.setColor(Color.LIGHT_GRAY);
//        g.drawRect(xoff, yoff, labelWidth, labelHeight);
        g.setColor(Color.BLACK);

        String s[] = ar.getRecordAsSingleArray();
        g.setFont(font);
        int fontHeight = font.getSize();
        Lines allShortStrings = new Lines();
        Lines fieldShortStrings = new Lines();

        //Mailing labels built from Name and Address fields
        //(AddressRecord: 1st two fields)
        for (int i = 0; i < 2; i++) {
            //Process each display line (e.g. street, city/state)
            //separately
            String[] temp = s[i].split("\n");
            for (int k = 0; k < temp.length; ++k) {
                //Break field into label-width chunks
                fieldShortStrings.set(substringify(temp[k]));
                for (int ss = 0; ss < fieldShortStrings.size(); ++ss) {
                    //Add chunks to complete address vector
                    allShortStrings.add(fieldShortStrings.elementAt(ss));
                }
            }
        }

        int termCount = allShortStrings.size();
        if (termCount * fontHeight > labelHeight) {
            StringBuffer al = new StringBuffer();
            for (int ll = 0; ll < allShortStrings.size(); ++ll) {
                al.append(allShortStrings.elementAt(ll));
                al.append('\n');
            }
            al.append("Address will not fit label!");
            al.append("\nChoose smaller font or larger label");
            System.out.println(al.toString());
        }

        for (int j = 0; j < termCount; ++j) {
            int localX = xoff;
            int localY = yoff + (j + 1) * fontHeight;
            String currentString = allShortStrings.elementAt(j);
            Rectangle2D rect = font.getStringBounds(currentString,
                    0,
                    currentString.length(),
                    g.getFontRenderContext());
            double stringWidth = rect.getWidth();
            double whiteSpace = labelWidth - stringWidth;
            localX += (int)whiteSpace/2;
            double textHeight = allShortStrings.size() * fontHeight;
            whiteSpace = labelHeight - textHeight;
            localY += (int)whiteSpace/2;
            g.drawString(currentString, localX, localY);
        }
        fieldShortStrings.removeAllElements();

        xoff += (labelWidth + lb.getHorizontalGutter());
        if (xoff > labelWidth * columns) {
            xoff = lb.getLeftMargin();
            yoff = yoff + labelHeight + lb.getVerticalGutter();
        }
    }
}
