/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import utils.CompactJava;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 30, 2005
 * <p/>
 * Time: 4:28:24 PM
 */
public class PreferencesBean implements Serializable{
    private static final String key = "JAddressBook.PreferencesBean";
    private String fileName = null;
    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return CompactJava.toXml(this);
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static PreferencesBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new PreferencesBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (PreferencesBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new PreferencesBean();
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}
