/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 12:30:51 PM
 */
package utils;

import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.swing.*;
import java.awt.*;
import java.awt.print.*;
import java.io.RandomAccessFile;

public class PrintUtils implements Printable {
    private RandomAccessFile raf;
    private String fileName;
    private int rememberedPageIndex = -1;
    private long rememberedFilePointer = -1;
    private boolean rememberedEOF = false;
    private Font font = new Font("times", Font.ITALIC, 14);
    private PageFormat globalPageFormat = null;

    public PrintUtils(String file) {
        fileName = file;
        try {
            // Open file
            raf = new RandomAccessFile(file, "r");
        } catch (Exception e) {
            rememberedEOF = true;
        }
    }

    public PrintUtils() {
        this(futils.Futil.getReadFileName("select a file to print"));
    }

    public static void printFile() {
        PrinterJob job = PrinterJob.getPrinterJob();
        // Specify the Printable is an instance of SimplePrint
        job.setPrintable(new PrintUtils());
        // Put up the dialog box
        if (job.printDialog()) {
            // Print the job if the user didn't cancel printing
            try {
                job.print();
            } catch (Exception e) { /* handle exception */
                e.printStackTrace();
            }
        }
        System.exit(0);
    }


    public int print2(Graphics g, PageFormat pf, int pageIndex)
            throws PrinterException {
        try {
            // For catching IOException
            if (pageIndex != rememberedPageIndex) {
                // First time we've visited this page
                rememberedPageIndex = pageIndex;
                // If encountered EOF on previous page, done
                if (rememberedEOF) return Printable.NO_SUCH_PAGE;
                // Save current position in input file
                rememberedFilePointer = raf.getFilePointer();
            } else
                raf.seek(rememberedFilePointer);
            g.setColor(Color.black);
            g.setFont(font);
            int x = (int) pf.getImageableX() + 10;
            int y = (int) pf.getImageableY() + 12;
            // Title line
            g.drawString(
                    "File: " +
                    fileName +
                    ", page: " +
                    (pageIndex + 1), x, y);
            // Generate as many lines as will fit in imageable area
            y += 36;
            while (y + 12 < pf.getImageableY() + pf.getImageableHeight()) {
                String line = raf.readLine();
                if (line == null) {
                    rememberedEOF = true;
                    break;
                }
                g.drawString(line, x, y);
                y += 12;
            }
            return Printable.PAGE_EXISTS;
        } catch (Exception e) {
            return Printable.NO_SUCH_PAGE;
        }
    }


    private Component componentToBePrinted;

    public static void printComponent(Component c) {
        PrintUtils printUtils = new PrintUtils(c);
        //new PrintPreview(printUtils);
        printUtils.print();
    }

    public PrintUtils(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog())
            try {
                printJob.print();
            } catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
    }

    public int print(
            Graphics g,
            PageFormat pageFormat,
            int pageIndex) {

        if (globalPageFormat == null) {
            globalPageFormat = pageFormat;
        }
        g.setFont(font);
        if (pageIndex > 0)
            return (NO_SUCH_PAGE);

        Graphics2D g2d = (Graphics2D) g;
        g2d.translate(
                globalPageFormat.getImageableX(),
                globalPageFormat.getImageableY());
        disableDoubleBuffering(componentToBePrinted);
        componentToBePrinted.paint(g2d);
        enableDoubleBuffering(componentToBePrinted);
        return (PAGE_EXISTS);

    }

    /**
     * The speed and quality of printing suffers dramatically if any of the
     * containers have double buffering turned on. So this turns if off
     * globally.
     */
    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    /**
     * Re-enables double buffering globally.
     */

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public Font getFont() {
        return font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public PageFormat getGlobalPageFormat() {
        return globalPageFormat;
    }

    public void setGlobalPageFormat(PageFormat globalPageFormat) {
        this.globalPageFormat = globalPageFormat;
    }

    public void printFormat() {
        if (globalPageFormat == null) return;
        print(globalPageFormat);
        print(globalPageFormat.getPaper());
    }

    public static void print(PageFormat pageFormat) {
        System.out.println("pageFormat=" + pageFormat);
        System.out.println(
                "getImageableWidth=" +
                pageFormat.getImageableWidth());
        System.out.println(
                "getImageableHeight=" +
                pageFormat.getImageableHeight());
        System.out.println(
                "getImageableX=" +
                pageFormat.getImageableX());
        System.out.println(
                "getImageableY=" +
                pageFormat.getImageableY());
        System.out.println(
                "getPaper=" +
                pageFormat.getPaper());
        System.out.println(
                "getOrientation=" +
                pageFormat.getOrientation());
    }

    public static void print(Paper p) {
        System.out.println("Paper----");
        println(p.getWidth() + "," + p.getHeight() + "=w,h");
        println(
                p.getImageableWidth() +
                "," +
                p.getImageableHeight() +
                "=imw,imh");
        println(p.getImageableX() + "," + p.getImageableY() + "=imx,imy");
    }

    public static void println(Object o) {
        System.out.println(o.toString());
    }

    public static void testListPrintServices() {
        PrintService pss[] =
                getPrintServices();

        for (int i = 0; i < pss.length; ++i) {

            print(pss[i]);

        }
    }

    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    public static void print(PrintService ps) {
        print(ps.getAttributes());
        print(ps.getSupportedDocFlavors());
        
    }

    private static void print(DocFlavor[] supportedFlavors) {
        for (int j = 0; j < supportedFlavors.length; ++j) {
            System.out.println("  flavor: " + supportedFlavors[j]);
        }
    }

    private static void print(PrintServiceAttributeSet psas) {
        Attribute attributes[] = psas.toArray();
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            System.out.println("  attribute: " + attribute.getName());

            if (attribute instanceof PrinterName) {
                PrinterName pn = (PrinterName) attribute;
                System.out.println(
                        "    printer name: " + pn.getValue());
            }
        }
    }
}


