/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 3, 2003
 * Time: 5:45:44 PM
 */
package sound.recorder;

import gui.In;
import j2d.ImagePanel;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import j2d.color.IndexImageBean;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

//todo
// 1. Figure out how to digitize sound into a buffer
//   try CapturePlayBackOscope
// 2. Decide how to windows the incomming audio signal
//   a. What window should we use?
//   b. How do we decide what the overlap should be?
//   c. What is the size of the window?
//   d. Where are the windowing functions?
//    check out SoundUtils for windowing functions....
// 3. Which dft is faster? Is PFA faster that FFT-Radix 2?
//     Are direct methods faster for shorter windows?
// 4. Figure out how to get the PSD for each FFT.
// 5. Figure out how to display the PSD for an input audio signal.
// 6. Figure out how to display the index color image of a spectrogram.
// 7. Don't forget to use labels on your data. Check out: graph.Main.notSoSimpleTest();

public class SpectrogramFrame extends JFrame {
    private IndexImageBean iib =
            getSpectrogramIndexBean();

    public static IndexImageBean getIndexImageBean() {
        try {
            return new IndexImageBean(new ShortImageBean(//ImageUtils.getImage()));
                    ImageUtils.captureWholeScreen()));
        } catch (AWTException e) {
            return null;

        }
    }

    public static IndexImageBean getSpectrogramIndexBean() {
        return new IndexImageBean(getSpectrogramImageBean());
    }

    public static ShortImageBean getSpectrogramImageBean() {
        ShortImageBean sib = new ShortImageBean(200, 200);
        short b[][] = sib.getB();
        for (int i = 0; i < b.length; i++) {
            for (int j = 0; j < b[0].length; j++) {
                b[i][j] = (short) (i);
            }
        }
        return sib;
    }

    // private ImageProcessButton ip =
//        new ImageProcessButton(iib.getImage());
    private ImagePanel ip = new ImagePanel(iib.getImage());

    public void incrementImage() {
        iib.add((byte) 1);
        //ip.setImage(iib.getImage());
        ip.setImage(iib.getImage());
    }


    public static void main(String[] args) {
        new SpectrogramFrame();
        //todo create a graph of the spectrogram
        //graphics.grapher.Main.main(args);
    }

    public static short getRandom() {
        return (short) (Math.random() * 255);
    }

    public Image getIndexImage() {
        IndexImageBean iib = new IndexImageBean(new ShortImageBean(getImage()));
        return iib.getImage();
    }

    public Image getImage() {
        ShortImageBean sib = new ShortImageBean(400, 400);
        short r[][] = sib.getR();
        short g[][] = sib.getG();
        short b[][] = sib.getB();
        for (int x = 0; x < r.length; x++)
            for (int y = 0; y < r[0].length; y++) {
                int xc = x - 200;
                int yc = y - 200;
                if ((xc * xc + yc * yc) < 10000) {
                    r[x][y] = getRandom();
                    g[x][y] = getRandom();
                    b[x][y] = getRandom();
                }
            }
        return sib.getImage();
    }

    public SpectrogramFrame() {
        Container c = super.getContentPane();
        gui.layouts.PreferredSizeGridLayout
                lo = new gui.layouts.PreferredSizeGridLayout(0, 1);
        lo.setBoundableInterface(new
                gui.layouts.AspectBoundable());

        c.setLayout(lo);


        c.add(ip);
        setSize(200, 200);
        setDefaultCloseOperation(HIDE_ON_CLOSE);
        setVisible(true);
        ip.addMouseMotionListener(new MouseMotionAdapter() {
            public void mouseDragged(MouseEvent event) {
                Point p = event.getPoint();
                iib.drawDot(p.x, p.y);
            }
        });
        for (; true;) {
            incrementImage();
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                In.message(e);

            }
        }

    }
}
