package sound.musica;

import gui.run.RunJob;

import javax.sound.midi.*;

public class TestMidi {
    private Synthesizer synth = null;
    private MidiChannel channels[] = null;
    private int channelNumber = 10;
    // channel 10 is the percussion channel;
    final int ACOUSTIC_BASS = 35;
    final int ACOUSTIC_SNARE = 38;
    final int HAND_CLAP = 39;
    final int PEDAL_HIHAT = 44;
    final int LO_TOM = 45;
    final int CLOSED_HIHAT = 42;
    final int CRASH_CYMBAL1 = 49;
    final int HI_TOM = 50;
    final int RIDE_BELL = 53;

    final int PROGRAM = 192;


    public TestMidi() {

        // 1 & 2) Get Synthesizer
        getSynthesizer();
        // 3) Open Synthesizer
        openSynthesizer();
        System.out.println("synth.isOpen() = " + synth.isOpen());
        // 4) Get Channels from Synthesizer
        channels = synth.getChannels();
        System.out.println("channels = " + channels);
        // Play a note
        double alpha = 1;
        Instrument instruments[] =
                synth.getAvailableInstruments();
        for (int i=0; i < instruments.length; i++)
            System.out.println(instruments[i].toString()+i);

        repeatNote(instruments[410], .3 * alpha, 42);
        repeatNote(instruments[409], .5 * alpha, 42);
        repeatNote(instruments[408], .7 * alpha, 42);
        repeatNote(instruments[407], 1.3 * alpha, 42);
        repeatNote(instruments[406], 1.7 * alpha, 42);
        repeatNote(instruments[405], 2.3 * alpha, 42);
        repeatNote(instruments[0], 2.7 * alpha, 42);


        sleep(5 * 3 * 7 * 2 * 1000);

        synth.close();
    }

    private void repeatNote(Instrument instrument, double interval, final int nn) {
        synth.loadInstrument(instrument);
        new RunJob(interval) {
            public void run() {
                playNote(nn);
            }
        };
    }

    private void playNote(int nn) {
        MidiChannel mc = channels[channelNumber];
        mc.programChange(PROGRAM);
        mc.noteOn(nn, 127);
        sleep(150);
        mc.noteOff(nn, 127);
    }

    private void testOpenSynthesizer() {
        openSynthesizer();
        System.out.println("synth=" + synth);
        System.out.println("synthOpen=" + synth.isOpen());
    }

    private void openSynthesizer() {
        try {
            synth.open();
        } catch (MidiUnavailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void testGetSynthesizer() {
        getSynthesizer();
    }

    private void getSynthesizer() {
        try {
            synth = MidiSystem.getSynthesizer();
        } catch (MidiUnavailableException e) {
            System.out.println("Synthesizer not available");
        }
    }

    private Synthesizer initSynth() {
        if (synth != null)
            return synth;
        try {
            synth = MidiSystem.getSynthesizer();
        } catch (MidiUnavailableException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        return synth;

    }

    private static void sleep(int nDuration) {
        try {
            Thread.sleep(nDuration);
        } catch (InterruptedException e) {
        }
    }

    public static void main(String[] args) {
        //testNote();

        TestMidi tm = new TestMidi();
        //tm.testOpenSynthesizer();
        System.out.println("This is TestMidi");
    }
}
