package sound.musica;

import java.util.StringTokenizer;
import java.util.Vector;

public class PetriNode {

    private String identifier;
    private Vector nextNodes = new Vector();

    public void addNext(int i) {
        nextNodes.addElement(new Integer(i));
    }

    public static String[]
            getTokens(String s) {

        StringTokenizer
                st = new StringTokenizer(
                        s, ",: \t\n\r\f\\");
        int n = st.countTokens();
        String t[] = new String[n];
        for (int i = 0; i < n; i++)
            t[i] = st.nextToken();
        return t;
    }

    public static int[] getNotes(String s[]) {
        int ia[] = new int[s.length];
        for (int i = 0; i < ia.length; i++)
            ia[i] = Integer.parseInt(s[i]);
        return ia;
    }

    public void play() {
        int ia[] = getNotes(getTokens(identifier));
        sound.Utils.playThread(ia, 127, 1000);
    }

    public int getNext() {
        if (nextNodes.size() == 0) return 0;
        int r = (int) (nextNodes.size() * Math.random());
        Object o = nextNodes.elementAt(r);
        return ((Integer) o).intValue();
    }


    public PetriNode(String _identifier) {
        identifier = _identifier;
    }

    public String getIdentifier() {
        return identifier;
    }

    public boolean equals(PetriNode p2) {
        return this.getIdentifier().equals(p2.getIdentifier());
    }

    public String toString() {
        return
                "id=" + identifier
                + "\nNextNodes:" + nextNodes.toString();
    }


}