package sound;


import sound.ulaw.UlawCodec;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 10, 2003
 * Time: 6:45:03 PM
 * To change this template use Options | File Templates.
 */

public class VoiceUtil {
    private Voice v[] = {
        new Voice(550),
        new Voice(440),
        new Voice(330),
        new Voice(660)
    };
   /**
    * All the computation is done here.
    * @return  a waveform for a 4 voice synthesizer
    */
    public double[] getVoicedWave() {
        return add(
                add(
                        add(v[0], v[1]),
                        v[2].getVoicedWave()),
                v[3].getVoicedWave()
        );
    }
    public Voice [] getVoices() {
        return v;
    }

    public double[] add(Voice v1, Voice v2) {
        double a1[] = v1.getVoicedWave();
        double a2[] = v2.getVoicedWave();
        return add(a1, a2);
    }

    public double[] add(double a[], double b[]) {
        for (int i = 0; i < a.length; i++)
            a[i] = a[i] + b[i];
        return a;
    }
    /**
     * play the 4 voice sample.
     */
    public void play() {
        UlawCodec ulc = new UlawCodec(getVoicedWave());
        ulc.play();
    }
    /**
     *
     * @param _v The voice we want to set.
     * @param i a number from 0,1,2 or 3
     */

    public void setVoice(Voice _v, int i) {
        if (i < 0 || i > 3) {
            System.out.println("i out of range, i=" + i);
            return;
        }
        v[i] = _v;
    }

    public static void main(String args[]) {
        (new VoiceUtil()).play();
    }

}
