package serialPort;

import gnu.io.*;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 7, 2005
 * <p/>
 * Time: 6:47:35 AM
 */
public class TurnTable {
    public static void openAndClosePort(CommPortIdentifier cpid)
            throws PortInUseException {
        CommPort port = cpid.open("TurnTable", 20);
        System.out.println("  Opened successfully");
        port.close();
    }

    public static void testTurnTable()
            throws
            PortInUseException,
            IOException,
            UnsupportedCommOperationException {
        CommPortIdentifier portId;
        System.out.println("getPortIdentifiers...");
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu == null) return;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        System.out.println("getPortIdentifiers... done!");

        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier) portList.nextElement();
            if
            (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                if (portId.getName().equals("COM3")) {
                    processPort(portId);

                }

            }

        }
    }

    public static void processPort(CommPortIdentifier portId)
            throws PortInUseException,
                   IOException,
                   UnsupportedCommOperationException {
        System.out.println("portId=" + portId.getName());
        SerialPort sp =
                openSerialPort(portId);

        OutputStream os = sp.getOutputStream();
        setUpSerialPort(sp);
        sendMagicNumber(os);
        sleepSec(10);
        moveStepperMotor(os);
        closeSerialPort(sp);
        System.out.println("port closed");
        System.in.read();
    }

    public static void sendMagicNumber(OutputStream os)
            throws IOException {
        byte[] mn = {27, 13, 27, 13, 27, 13, 0};
        os.write(mn);
        System.out.println("Send magic number..");
    }

    public static void moveStepperMotor(OutputStream os)
            throws IOException {
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        os.write(st);
        System.out.println("Move step.");
    }

    public static void closeSerialPort(SerialPort sp) {
//tt.step(1);
//sleepSec(2);
//tt.step(2);
//sleepSec(2);
//tt.step(3);
//sleepSec(2);

        sp.close();
    }

    public static void step(OutputStream os, int n) throws IOException {
        System.out.println("Move " + n + " steps");
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        for (int i = 0; i < n; i++)
            os.write(st);
    }

    public static SerialPort openSerialPort(CommPortIdentifier portId)
            throws PortInUseException {
        return (SerialPort)
                portId.open("SimpleWriteApp", 2000);

    }

    public static void setUpSerialPort(SerialPort sp)
            throws UnsupportedCommOperationException {
        sp.setSerialPortParams(
                9600, SerialPort.DATABITS_8,
                SerialPort.STOPBITS_2, SerialPort.PARITY_NONE);
    }

    public static void sleepSec(int sec) {

        try {

            Thread.sleep(sec * 1000);

        } catch (InterruptedException e) {
        }

    }
}
