/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package security;

import java.io.*;
import java.util.Vector;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 20, 2005
 * <p/>
 * Time: 7:13:57 AM
 */
public class JnlpBean implements Serializable{
    private final static String key = "JnlpBean";
    private boolean uploadJnlpFile = false;
    private Vector jarFileNames = new Vector();

    public void addJarFileName(String s){
         jarFileNames.addElement(s);
    }
    public String[] getJarFileNames(){
        String s[] = new String[jarFileNames.size()];
        jarFileNames.copyInto(s);
        return s;
    }
    /**
     * restores the properties from the preference in the user root.
     */
    public static JnlpBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new JnlpBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (JnlpBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            //e.printStackTrace();
        }
        return new JnlpBean();
    }
    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            byte[] value = baos.toByteArray();
            p.putByteArray(key, value);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isUploadJnlpFile() {
        return uploadJnlpFile;
    }

    public void setUploadJnlpFile(boolean uploadJnlpFile) {
        this.uploadJnlpFile = uploadJnlpFile;
    }
}
