package rtf;

import futils.Futil;
import gui.In;

import java.io.File;


/**
 * DocJava, Inc. User: lyon Date: Aug 15, 2004
 * Time: 11:30:43 AM
 */
public class JavaDocUtil {
    public static void main(String args[]) {
        String packageName = In.getString("enter package name");
        String options[] = {
            "html",
            "rtf"
        };
        String sourcePath = getSourcePath();
        String format = (String) In.multiPrompt(options, "output format", "format seletor");
        if (format.equals("rtf"))
            outputRtf(packageName, sourcePath);
        if (format.equals("html"))
            outputHtml(packageName, sourcePath);
        In.message("done generating javadoc");
    }

    private static String getSourcePath() {
        final String sourcePath = "/Users/lyon/current/java/j4p/src";
        File f = new File(sourcePath);
        if (f.exists()) return sourcePath;
        return Futil.getReadDirFileJTree("select source path").toString();
    }

    public static void outputHtml(String packageName, String sourcePath) {
        final String windowTitle = "Another fine DocJava, Inc. API";
        final String destination = "/home/lyon/current/java/j4p/docs";

        outputHtml(windowTitle,
                destination,
                sourcePath,
                packageName);
    }

    public static void outputHtml(final String windowTitle,
                                  final String destination,
                                  final String sourcePath,
                                  final String packageName) {
        String[] javadocargs = {"-public",
                                "-splitindex",
                                "-use",
                                "-author",
                                "-version",
                                "-windowtitle", windowTitle,
                                "-d", destination,
                                "-sourcepath", sourcePath,
                                packageName};
        runJavaDoc(javadocargs);
    }

    public static void outputRtf(String packageName, String sourcePath) {
        final String docletPath = "/Users/lyon/current/java/j4p/jars/RTFDoclet.jar";
        outputRtf(docletPath, sourcePath, packageName);
    }

    public static void outputRtf(final String docletPath,
                                 final String sourcePath,
                                 final String packageName) {
        String[] javadocargs = {"-public",
                                "-docletpath", docletPath,
                                "-doclet", "RTFDoclet",
                                "-sourcepath", sourcePath,
                                "-filename", "docs/" +
                packageName +
                ".rtf",
                                packageName};
        runJavaDoc(javadocargs);
    }

    public static void runJavaDoc(String[] javadocargs) {
        com.sun.tools.javadoc.Main.main(javadocargs);
    }
}
