/**
 Christopher Scaglione and Doug Lyon
 SW409
 Midterm
 */

package rtf;

import futils.Futil;
import futils.ReaderUtil;
import futils.WriterUtil;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;

public class Java2Rtf {

    public static void main(String args[]) {
        if (args.length < 2) {
            runGui();
            return;
        }
        if (args.length == 2) {
            processTwoArgs(args);
            return;
        }
        processManyArgs(args);

    }

    private static void processManyArgs(String args[]) {
        for (int i = 0; i < args.length; i++) {
            BufferedWriter bw = WriterUtil.getBufferedWriter(
                    new File(args[i] + ".rtf"));

            BufferedReader br =
                    ReaderUtil.getBufferedReader(new File(args[i]));
            System.out.println("processing file:" + args[i]);
            javaToRtf(br, bw);
        }
    }

    private static void processTwoArgs(String[] args) {
        System.out.println("files:" + args[0] + " " + args[1]);
        BufferedReader br = ReaderUtil.getBufferedReader(new File(args[0]));
        BufferedWriter bw = WriterUtil.getBufferedWriter(new File(args[1]));
        javaToRtf(br, bw);
    }

    public static void javaToRtf(BufferedReader br, BufferedWriter bw) {
        processFileNoClose(br, bw);
        close(bw);
        System.out.println("Done!");
    }

    private static void close(BufferedWriter bw) {
        WriterUtil.close(bw);
    }

    private static void processFileNoClose(BufferedReader br, BufferedWriter bw) {
        RtfUtil ru = new RtfUtil();
        ru.javaToRtf(br, bw);
    }

    public static void runGui() {
        File f = Futil.getReadFile("select java file");
        BufferedWriter bw = WriterUtil.getBufferedWriter("enter the output file");
        BufferedReader br = ReaderUtil.getBufferedReader(f);
        javaToRtf(br, bw);
    }
}
