package net.server.servlets;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Vector;

/**
 * RequestUtil Class
 */

public class RequestUtil {

    /**
     * Returns the parameters as an array
     *
     * @return		String[]
     */

    public static String[] getParmNames(HttpServletRequest request) {

        Vector v = new Vector();

        Enumeration e =
                request.getParameterNames();

        while (e.hasMoreElements())
            v.addElement(e.nextElement());

        String s[] = new String[v.size()];

        for (int i = 0; i < s.length; i++)
            s[i] = (String) v.elementAt(i);

        return s;

    }

    /**
     * Returns the parameter values as an array
     *
     * @return		String[]
     */

    public static String[] getParmValues(String pn[],
                                         HttpServletRequest request) {

        String pv[] = new String[pn.length];

        for (int i = 0; i < pn.length; i++)
            pv[i] = request.getParameter(pn[i]);

        return pv;
    }

    /**
     * Returns the cookie value
     *
     * @return		 String         cookieValue
     */

    public static String getCookieValue(Cookie[] cookies, String cookieName) {

        for (int i = 0; i < cookies.length; i++) {
            Cookie cookie = cookies[i];
            if (cookieName.equals(cookie.getName()))
                return (cookie.getValue());
        }

        return null;
    }

    /**
     * Returns the Cookies as an array
     *
     * @return		 Cookie 	    cookie
     */

    public static Cookie getCookie(Cookie[] cookies, String cookieName) {

        for (int i = 0; i < cookies.length; i++) {
            Cookie cookie = cookies[i];
            if (cookieName.equals(cookie.getName()))
                return cookie;
        }

        return null;
    }

}

