package net.server.servlets;

import javax.servlet.http.HttpServletRequest;

/**
 * The ConfirmationPage class is a type of HTML page
 * which is used to display the results of the student
 * assessment form, or ReviewForm. This data is displayed
 * in a table format.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class ConfirmationPage extends HtmlPage {

    /**
     * This is the constructor for the ConfirmationPage class.
     * An object of type HttpServletRequest is passed in as
     * a parameter and parsed for data pertaining to the student
     * assessment results from the Form C page. This data is
     * then displayed in a table format. The user is prompted
     * to 'Proceed' at the bottom of the page, once they have
     * reviewed the data.
     */
    ConfirmationPage(HttpServletRequest request) {
        super("Confirmation Page");

        String course = new String();
        String section = new String();
        String term = new String();
        String year = new String();

        course = request.getParameter("course");
        section = request.getParameter("section");
        term = request.getParameter("term");
        year = request.getParameter("year");

        addHeadline(1, "Course:");
        addBreak();
        addText(course + "section: " + section);
        addBreak();
        addHeadline(1, "Term:");
        addBreak();
        addText(term);
        addBreak();
        addHeadline(1, "Instructor:");
        addBreak();
        addText(request.getParameter("instructor"));
        addBreak();
        startForm("get",
                "http://localhost:8080/examples/servlet/FormProcessorServlet");
        int rowCount = Integer.parseInt(request.getParameter("rows"));
        int colCount = Integer.parseInt(request.getParameter("cols"));

        HtmlTable table = new HtmlTable(rowCount + 1, colCount, 1);

        for (int rowIndex = 0; rowIndex < rowCount; rowIndex++)
            table.setElement(rowIndex + 1,
                    0,
                    request.getParameter("student" +
                    rowIndex));
        for (int colIndex = 0; colIndex < colCount; colIndex++)
            table.setElement(0,
                    colIndex,
                    request.getParameter("heading" +
                    colIndex));
        for (int rowIndex = 1; rowIndex <= rowCount; rowIndex++)
            for (int colIndex = 1; colIndex < colCount; colIndex++)
                table.setElement(rowIndex,
                        colIndex,
                        request.getParameter("r" +
                        rowIndex +
                        "c" +
                        colIndex));
        addText(table.getHtml());
        addBreak();
        addSubmit("Proceed");

        for (int rowIndex = 0; rowIndex < rowCount; rowIndex++)
            addHidden("recordnum" + rowIndex,
                    "" + request.getParameter("recordnum" + rowIndex));

        for (int rowIndex = 1; rowIndex <= rowCount; rowIndex++)
            for (int colIndex = 1; colIndex < colCount; colIndex++)
                addHidden("r" + rowIndex + "c" + colIndex,
                        request.getParameter("r" + rowIndex + "c" + colIndex));

        addHidden("status", "confirmed");
        addHidden("course", course);
        addHidden("section", section);
        addHidden("term", term);
        addHidden("year", year);
        addHidden("rows", "" + rowCount);
        addHidden("cols", "" + colCount);
        endForm();
    }
}