package net.rmi.rjs.pk.rmissl;



import futils.Futil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

/**
 * Created by IntelliJ IDEA.
 * User: pkrepszt
 * Date: Nov 14, 2004
 * Time: 6:57:21 PM
 * To change this template use File | Settings | File Templates.
 */
public class RmiSslFileClient {
    private RmiSslInterface rsi = null;

    public RmiSslFileClient(){}
    private RmiSslInterface lookupServer(String rmiUrl)
            throws NotBoundException,
            java.net.MalformedURLException,
            RemoteException {
        System.out.println("Naming.lookup(rmiUrl) " + rmiUrl);
        RmiSslInterface sch = (RmiSslInterface)
                Naming.lookup(rmiUrl);
        return sch;
    }
    public void putFile(File f, String wsAnwserURL) {
        String address = getRMIString(wsAnwserURL);
        System.out.println("Location to send file " + address);
        System.out.println("RMISSLFILECLIENT "+ f.getName()+" "+ f.getAbsolutePath());;
        try {
            rsi = lookupServer(address);
            byte b[] = Futil.readBytes(f);
            rsi.putFile(f.getName(), b, wsAnwserURL);

        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String[] getJobJnlpFileList(String wsAnwserURL) {
        String jnlpList[];
        String address = getRMIString(wsAnwserURL);
        System.out.println("Getting list of jnlp jobs files" + address);
        try {
            rsi = lookupServer(address);
            jnlpList = rsi.getJobsJnlp();
            return jnlpList;
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getRMIString(String wsAnwserURL){
        return "rmi://" + wsAnwserURL +"/"+RmiSSLImplementation.REMOTE_NAME;
    }
    public static String getStackTrace(Exception e){
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        try {
            baos.close();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return new String(baos.toByteArray());
    }



}
