package net.rmi.rjs.pk.rmissl;

import futils.Futil;
import net.web.UrlUtils;
import utils.SystemUtils;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: pkrepszt
 * Date: Jun 4, 2005
 * Time: 12:30:50 PM
 * To change this template use File | Settings | File Templates.
 */
public class RmiSSLImplementation extends UnicastRemoteObject
        implements RmiSslInterface {

    public static String REMOTE_NAME = "RmiSslImplementation";
   /**
    * construct RMI SSL socket on given port
    * @param port SSL port
    * @throws RemoteException
    */
    public RmiSSLImplementation(int port)
            throws RemoteException {
        super(port , new RMISSLClientSocketFactory(),
                new RMISSLServerSocketFactory());
    }
    /**
     * test method
     * @return  string + date time
     * @throws RemoteException
     */
    public String printInfo() throws RemoteException {
        Date d = new Date();
        String s = d.toString();
        return new StringBuffer().append("This must work for me now!!!! ").append(s).toString();
    }
   /**
    * Upload answer jar to WS
    * @param fileName answer jar name
    * @param data array of file byts
    * @param wsAnwserURL
    * @throws RemoteException
    */
    public void putFile(String fileName, byte data[], String wsAnwserURL)
            throws RemoteException {
        if (data == null) System.out.println("RMISSL Data=null!");
        // make dir
        wsAnwserURL = SystemUtils.getUserHome() + SystemUtils.getDirectorySeparator() +
                "ans" + SystemUtils.getDirectorySeparator();
               // "ans" + SystemUtils.getDirectorySeparator();
        File user = new File(wsAnwserURL);
        user.mkdirs();

        File f = new File(wsAnwserURL + fileName);
        Futil.writeBytes(f, data);
        System.out.println("wrote file:" + f.getAbsolutePath());

    }

    /**
     * Gets a jobs from web server
     * @return  returns a array of jnlp jobs
     * @throws RemoteException
     */
    public String[] getJobsJnlp() throws RemoteException {
        String urlList[] = UrlUtils.getHrefs(UrlUtils.getOneBigUrlString(
                "http://show.docjava.com:8086/book/cgij/code/jnlp/jobs/" ),".jnlp");
        return urlList;
    }
}
