package net.rmi.rjs.pk.rmissl;


import javax.net.ssl.*;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;

/**
 * Created by IntelliJ IDEA.
 * User: pkrepszt
 * Date: Nov 16, 2004
 * Time: 7:28:13 PM
 * To change this template use File | Settings | File Templates.
 */
public class RMISSLServerSocketFactory implements RMIServerSocketFactory, Serializable {
    /**
     * RMISSLServerSocketFactory opens SSL concetion over RMI
     * @param port SSl port
     * @return
     * @throws IOException
     */
    public ServerSocket createServerSocket(int port)
            throws IOException {
        ByteArrayInputStream serverKeyStoreInputStream =
                new ByteArrayInputStream(ServerKeyStoreFile.getSKSbytes());
        ByteArrayInputStream serverTrustStoreInputStream =
                new ByteArrayInputStream(ServerKeyStoreFile.getSTSbytes());

        SSLServerSocketFactory ssf = null;
        SSLServerSocket serverSocket = null;
        try {
            char[] passphrase = "paul27".toCharArray();

            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(serverKeyStoreInputStream, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(serverTrustStoreInputStream, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            ssf = ctx.getServerSocketFactory();
            serverSocket = (SSLServerSocket) ssf.createServerSocket(port);
            serverSocket.setNeedClientAuth(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
         System.out.println("RMISSLServerSocketFactory created socket on port "+ port);
        return serverSocket;
    }
}


















