/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.pk.LusCs;

import futils.Futil;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 29, 2005
 * <p/>
 * Time: 4:58:50 PM
 */
public class RemoteJob implements Serializable{
    private String returnAddress = null;
    private String jarFileName = null;
    private byte jarContents[] = null;

    public String getReturnAddress() {
        return returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getJarFileName() {
        return jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public byte[] getJarContents() {
        return jarContents;
    }

    public void setJarContents(byte[] jarContents) {
        this.jarContents = jarContents;
    }
    public String toString(){
        return "return address:"+returnAddress+"\n" +
                "JarFileName:"+jarFileName+"\n " +
                        "Number of Bytes:"+jarContents.length;
    }
    public static void main(String[] args) {
        RemoteJob rj = new RemoteJob();
        File f = Futil.getReadFile("select a jar file");
        rj.setJarFileName(f.getName());
        rj.setJarContents(Futil.readBytes(f));
        try {
            rj.setReturnAddress(LusRcvr.getLusIp());
        } catch (IOException e) {
            e.printStackTrace();

        }
        System.out.println(rj);
    }
}
