package net.rmi.rjs.pk.LusCs;


/**

 * Created by IntelliJ IDEA.

 * User: pkrepszt

 * Date: Feb 16, 2005

 * Time: 3:52:17 PM

 * To change this template use File | Settings | File Templates.

 */

//package net.multicast;

import gui.In;
import gui.JInfoFrame;
import gui.run.RunButton;
import net.multicast.McastUtil;
import net.rmi.rjs.pk.rmiFileTransfer.FileServer;
import net.rmi.rjs.pk.rmiFileTransfer.FileServerImplementation;
import net.rmi.rjs.pk.rmiFileTransfer.FileTransClient;
import net.rmi.rjs.pk.rmissl.RmiSslFileClient;
import net.web.UrlUtils;

import java.awt.*;
import java.net.InetAddress;
import java.util.ArrayList;
/**
 * Look Up Server
 * Registers avalable Compute Server
 * A man in the middel
 */

public class Lus {
    private int mcastPort = 7234;
    private McastUtil mcx = new McastUtil(mcastPort);
    private JInfoFrame jif = new JInfoFrame("LAN LUS");
    private FileTransClient ftc = new FileTransClient();
    public CsRecords csRecords = new CsRecords();
    private ArrayList jobsUrlList = new ArrayList();

    private String webServerIP = "";

    public Lus() {
        webServerIP = In.getString("enter Web Server Ip address");
        System.out.println("start file server!");
        FileServer.startFileServer();
        System.out.println("file server started!");
        mcx.enableLoopBack();
        processWithMulticastSocket();       
    }

    public void processWithMulticastSocket() {
        // LusRcvr will handle the incoming
        // Data and print it out to STDN output.
        new LusRcvr(mcx, jif, csRecords);
        Container c = jif.getContentPane();

        c.add(
                new RunButton("Get Jobs") {
                    public void run() {
                        getJar();
                    }
                }, BorderLayout.SOUTH);
        c.add(
                new RunButton("Exit") {
                    public void run() {
                        System.exit(0);
                    }
                }, BorderLayout.NORTH);
        jif.setSize(700, 300);
        jif.show();
    }

    public void getJar() {
        Thread t = new Thread(
                new Runnable() {
                    public void run() {
                        //1)connect to WS  evry 10 sec
                        //2)look for files
                        //3) get one
                        while(true){
                            String jobsUrls = getJobURL();
                            System.out.println("jobs "+ jobsUrls);
                            InetAddress bestIp = getBestIp();
                            System.out.println("bestIp " + bestIp);
                            if (jobsUrls == null || bestIp == null){

                                try {
                                    //if a job is avalable, but no CS
                                    // put remove from the list
                                    if(jobsUrls != null){
                                        System.out.println("CS avalable all busy ");
                                        jobsUrlList.remove(jobsUrls);
                                    }
                                    //if no jobs but best IP is selected
                                    //set the busy state beck to false
                                    //so it will be picked up next time
                                    if(jobsUrls == null && bestIp != null){
                                        System.out.println("No jobs avalable");
                                        csRecords.updateState(bestIp, false);
                                    }
                                    System.out.println("Sleeping 10 sec continue");
                                    Thread.sleep(10000);
                                    continue;
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }else if(jobsUrls != null && bestIp != null) {
                                try {
                                    Thread.sleep(1000);
                                    sendJobUrltoCs(jobsUrls,bestIp);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();                                  }

                            }
                        }
                    }
                });
        t.start();
    }

    // get the CS ip that the job will be send
    /**
     * String location = "rmi://" +serverHostName +"/" +REMOTE_NAME;
     */
    public String getRmiUrl(String ipAddress) {
        if (ipAddress == null)
            return null;

        String s = "rmi://" + ipAddress +
                "/" +
                FileServerImplementation.REMOTE_NAME;
        //System.out.println("Lus rmiUrl=" + s);
        return s;
    }

    public InetAddress getBestIp() {
        CsRecord cs = csRecords.getLeastLoaded();
        if (cs == null)
            return null;
        return  cs.getIpAddress();
    }

    public String[] getJobURLArray(){
        String url[] = UrlUtils.getHrefs(UrlUtils.getOneBigUrlString(
                "http://show.docjava.com:8086/book/cgij/code/jnlp/jobs/" ),".jnlp");
        for(int i =0; i< url.length; i++){
            url[i]= "http://show.docjava.com:8086/book/cgij/code/jnlp/jobs/"+ url[i];
            System.out.println(i +" = "+url[i]);
        }

        return url;
    }
    public String getJobURL(){

        RmiSslFileClient rsfc = new RmiSslFileClient();
        String urlList[] = rsfc.getJobJnlpFileList(webServerIP);

        for(int i =0; i< urlList.length; i++){
            urlList[i]= "http://show.docjava.com:8086/book/cgij/code/jnlp/jobs/"+ urlList[i];
            System.out.println(i +" = "+urlList[i]);
            // System.out.println(jobsUrlList.contains(urlList[i]));
            if(! jobsUrlList.contains(urlList[i])){
                jobsUrlList.add(urlList[i]);
                return urlList[i];
            }
        }
        return null;
    }
    public void sendJobUrltoCs(String url, InetAddress CSIp) {
        final String jobUrl =url;
        final InetAddress bestIp = CSIp;
        Thread job = new Thread(
                new Runnable() {
                    public void run() {
                        String bestIpAddress =  bestIp.toString();
                        bestIpAddress = bestIpAddress.substring(1);
                        String rmiUrl = getRmiUrl(bestIpAddress);
                        if (rmiUrl == null)
                            return;
                        System.out.println(" Best Ip is " + rmiUrl);
                        System.out.println(" Jnlp url " + jobUrl);
                        // now send this jar to CS over RMI?
                        //desin change ftc.putJobJar(rmiUrl, jar ,wsAnwserURL);
                        // check if the bestIpAddress still exist on the network
                        int status = ftc.putJobURL(rmiUrl,jobUrl,webServerIP);
                        // if cennot conect to cs remove it from the list
                        // put the job beck
                        //System.out.println(" status  " + status);
                        if(status!=0){
                            csRecords.deleteRecord(bestIp);
                            jobsUrlList.remove(jobUrl);
                            System.out.println("CS is not present, getting new CS");
                        } else{
                            System.out.println("the job is done" + jobUrl + " CS IP "+ bestIp);
                            csRecords.updateState(bestIp, false);
                        }

                    }
                });
        job.start();
    }
}





