package net.rmi.rjs.pk.LusCs;

import gui.In;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Observable;


/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Feb 28, 2005 Time:
 * 10:13:53 PM To change this template use File | Settings | File
 * Templates.
 */
public class CsRecord extends Observable {
    private InetAddress ipAddress ;

    private BenchMarkBean bmb ;
    private long timeSinceLastUpdateInMs = System.currentTimeMillis();
    private boolean busy = false;

    public CsRecord(){
        try {
            ipAddress = InetAddress.getLocalHost();
            System.out.println("InetAddress.getLocalHost " +  ipAddress);
        } catch (UnknownHostException e) {
            e.printStackTrace();

        }
        bmb = new BenchMarkBean();
    }

    public InetAddress getIpAddress() {
        return ipAddress;
    }


    public void setIpAddress(InetAddress ip) {
        ipAddress = ip;
        updateObservers();

    }

    public void updateObservers(){
        setChanged();
        notifyObservers();
    }
    public long getAge() {
        return timeSinceLastUpdateInMs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" CS Ip address: "+ getIpAddress().getHostAddress());
        sb.append("    Busy:  "+isBusy());
        sb.append("    MFlops:  "+ bmb);
        sb.append("    Age:  "+getAge());
        sb.append("\n-------------------------------" +
            "-------------------------------------------" +
            "--------------------------------------------\n");
        return sb.toString();
    }

    public BenchMarkBean getBmb() {
        return bmb;
    }

    public void setBmb(BenchMarkBean bmb) {
        if (this.bmb.getMflops() == bmb.getMflops()) return;
        this.bmb = bmb;
        updateObservers();
    }

    public boolean isBusy() {
        return busy;
    }

    public void setBusy(boolean busy) {
        if (this.busy == busy) return;
        this.busy = busy;
        updateObservers();
    }
}
