/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.jobs;

import gui.ClosableJFrame;
import j2d.ShortImageBean;

import java.awt.*;

public class FractalLogicOld {
    private final MandleBrotDimensions mandleBrotDimensions =
            new MandleBrotDimensions();
    private static final MandelTables mandelTables = new MandelTables();
    private Answers ans = new Answers();
    public FractalLogicOld(){

    }
    public int getColor(float pixelr, float pixeli) {
        float zr = 0;
        float zi = 0;
        float tmp = 0;
        int iter = 0;
        //z*z+c, in complex basically;
        do {
            iter++;
            tmp = zr;
            zr = zr * zr - zi * zi;
            zi = 2 * tmp * zi;
            zr = zr + pixelr;
            zi = zi + pixeli;
        } while (((zr * zr + zi * zi) <= 300) && (iter <= mandelTables.maxIter));
        if (iter > mandelTables.maxIter)
            return -1;
        else
            return iter;
    }
    public static void main(String[] args) {
        FractalLogicOld fl = new FractalLogicOld();
        fl.testMandelbrot();
    }
    public void testMandelbrot() {
        ClosableJFrame cjf = new MbFrame();
        cjf.setSize(400, 400);
        cjf.setVisible(true);
    }

    public Image getMandelbrot(int w, int h) {
        ShortImageBean sib = new ShortImageBean(w, h);
        mandelbrot(sib.getR(), sib.getG(), sib.getB());
        return sib.getImage();
    }

    public void mandelbrot(short[][] r, short[][] g, short[][] b) {
        int height = r[0].length;
        int width = r.length;
        int Clr;
        float pixelr, pixeli;
        for (int y = 0; y < height; y++)
            for (int x = 0; x < width; x++) {
                pixelr
                        = mandleBrotDimensions.getxMin() +
                        (float) x / width *
                        (
                        mandleBrotDimensions.getxMax() -
                        mandleBrotDimensions.getxMin());
                pixeli
                        = mandleBrotDimensions.getyMin() +
                        (float) y / height *
                        (
                        mandleBrotDimensions.getyMax() -
                        mandleBrotDimensions.getyMin());
                Clr = getColor(pixelr, pixeli);
                if (Clr == -1) {
                    r[x][y] = 255;
                    g[x][y] = 128;
                    b[x][y] = 0;
                } else {
                    r[x][y] = mandelTables.colorR[Clr % mandelTables.maxIter];
                    g[x][y] = mandelTables.colorG[Clr % mandelTables.maxIter];
                    b[x][y] = mandelTables.colorB[Clr % mandelTables.maxIter];
                }
            }
    }

    public int getMaxIter() {
        return mandelTables.maxIter;
    }

    public void setMaxIter(int maxIter) {
        mandelTables.maxIter = maxIter;
    }

    public Answers getAns() {
        return ans;
    }

    private class MbFrame extends ClosableJFrame {
        public MbFrame() {
            super("mandlebrot");
        }

        public void paint(Graphics g) {
            Dimension d = getSize();
            Image i = getMandelbrot(d.width, d.height);
            g.drawImage(i, 0, 0, this);
        }
    }
}
