/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.jobs;

import gui.In;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Observable;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jun 3, 2005
 * <p/>
 * Time: 6:31:04 AM
 */
public class ComputeThread extends Observable implements Runnable {
    private ComputeJob computeJob;
    private Serializable answer;

    public ComputeThread(ComputeJob cj){
        this.computeJob = cj;
        Thread t = new Thread(this);
        t.start();
    }
    public void run(){
        try {
            answer = computeJob.getAnswer();
        } catch (RemoteException e) {
            In.message(e);

        }
        setChanged();
        System.out.println("computed answer!");
        super.notifyObservers(answer);
    }

    public ComputeJob getComputeJob() {
        return computeJob;
    }

    public Serializable getAnswer() {
        return answer;
    }
}
